﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using LOG = Common.Logger;
using LOG_LEVEL = Common.Logger.Level;

namespace BackupSaveData
{
    public class CommandInterface
    {
        public static int Main(string[] rawArgs)
        {
            try
            {
                CommandArgument parsed;
                var parser = new Nintendo.Foundation.IO.CommandLineParser();

                if (false == parser.ParseArgs<CommandArgument>(rawArgs, out parsed))
                {
                    return 1;
                }

#if NN_BACKUPSAVEDATA_SYSTEM
                Console.WriteLine("========== BackupSaveDataSystem ==========");
#elif NN_BACKUPSAVEDATA_DEVICE
                Console.WriteLine("========== BackupSaveDataDevice ==========");
#else
                Console.WriteLine("========== BackupSaveData ==========");
#endif

                if (parsed.ExportCommand != null)
                {
                    return DoExport(parsed);

                }
                else if (parsed.ImportCommand != null)
                {
                    return DoImport(parsed);
                }
                return 1;
            }
            catch (Exception exception)
            {
                PrintException(exception);
                return 1;
            }
        }

        public static void PrintException(Exception exception)
        {
            Console.Error.WriteLine("[ERROR] {0}", exception.Message);
            Console.Error.WriteLine("StackTrace: {0}", exception.StackTrace);

            System.Diagnostics.Trace.WriteLine("StackTrace: {0}", exception.StackTrace);
        }

        public static int DoExport(CommandArgument args)
        {
            if(args.ExportCommand.Verbose)
            {
                LOG.SetLevel(LOG_LEVEL.LOG_INFO2);
            }

            int retval = args.ExportCommand.Run();
            if (retval == 0)
            {
                LOG.LogLine("Export succeeded.");
            }
            else
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Export failed.");
            }
            return retval;
        }

        public static int DoImport(CommandArgument args)
        {
            if (args.ImportCommand.Verbose)
            {
                LOG.SetLevel(LOG_LEVEL.LOG_INFO2);
            }

            int retval = args.ImportCommand.Run();
            if (retval == 0)
            {
                LOG.LogLine("Import succeeded.");
            }
            else
            {
                LOG.LogLine(LOG_LEVEL.LOG_ERROR, "Import failed.");
            }
            return retval;
        }
    }
}
