﻿using System;
using System.Diagnostics;
using SdkEnvironmentCheckerLibrary.Properties;

namespace SdkEnvironmentCheckerLibrary
{
    public static class ProcessHelper
    {
        public static int? Run(string target, out string output, out string error)
            => Run(target, string.Empty, string.Empty, out output, out error);

        public static int? Run(string target, string arguments, out string output, out string error)
            => Run(target, arguments, string.Empty, out output, out error);

        public static int? Run(string target, string arguments, string workingDirectory, out string output, out string error)
        {
            var filepath = FilePath.Create(target);

            if (!filepath.Exists)
            {
                output = null;
                error = string.Format(Resources.FileNotFound, target);
                return null;
            }

            arguments = arguments ?? string.Empty;
            workingDirectory = workingDirectory ?? string.Empty;

            var startInfo = new ProcessStartInfo(filepath.FullPath, arguments)
            {
                WorkingDirectory = workingDirectory,
                UseShellExecute = false,
                CreateNoWindow = true,
                RedirectStandardOutput = true,
                RedirectStandardError = true,
            };

            try
            {
                using (var process = Process.Start(startInfo))
                {
                    process.WaitForExit();

                    output = process.StandardOutput.ReadToEnd();
                    error = process.StandardError.ReadToEnd();

                    return process.ExitCode;
                }
            }
            catch (Exception e)
            {
                output = null;
                error = e.Message;
                return null;
            }
        }
    }
}
