﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace BackupRestoreGui
{
    class UsbDeviceLocker
    {
        private string Serial { get; set; }

        private StreamWriter Stream { get; set; }
        public UsbDeviceLocker() {}
        public bool Lock(string serial)
        {
            EnsureExistingDirectoryPath();
            if (!IsLocked(serial))
            {
                try
                {
                    Stream = File.CreateText(GetLockFilePath(serial));
                }
                catch (IOException)
                {
                    return false;
                }
                Serial = serial;
                return true;
            }

            return false;
        }

        public void Unlock()
        {
            if (!IsLocked())
            {
                return;
            }

            EnsureExistingDirectoryPath();
            Stream.Close();
            File.Delete(GetLockFilePath(Serial));
        }

        public bool IsLocked()
        {
            EnsureExistingDirectoryPath();
            return File.Exists(GetLockFilePath(Serial));
        }

        public static bool IsLocked(string serial)
        {
            EnsureExistingDirectoryPath();
            return File.Exists(GetLockFilePath(serial));
        }

        private static string GetLockFilePath(string serial)
        {
            return Path.Combine(GetDirecotryPath(), serial + ".lock");
        }

        private static string GetDirecotryPath()
        {
            return Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate", "Outputs");
        }

        private static void EnsureExistingDirectoryPath()
        {
            Directory.CreateDirectory(GetDirecotryPath());
        }
    }
}
