﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    /// <summary>
    /// 開発機の情報の保持を行います。
    /// </summary>
    internal sealed class TargetInfo
    {
        /// <summary>
        /// TargetInfo クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="name">開発機の名前です。</param>
        /// <param name="ipAddress">開発機の IP アドレスです。</param>
        /// <param name="port">開発機のポート番号です。</param>
        internal TargetInfo(string name, string ipAddress, int port)
        {
            this.Name = name;

            this.IpAddress = ipAddress;

            this.Port = port;
        }

        /// <summary>
        /// 開発機の名前を返します。
        /// </summary>
        internal string Name { get; private set; }

        /// <summary>
        /// 開発機の IP アドレスを返します。
        /// </summary>
        internal string IpAddress { get; private set; }

        /// <summary>
        /// 開発機のポート番号を返します。
        /// </summary>
        internal int Port { get; private set; }

        /// <summary>
        /// 開発機の情報の印字可能な表現を返します。
        /// </summary>
        /// <returns>開発機の情報の印字可能な表現です。</returns>
        public override string ToString()
        {
            return string.Format(
                "{0} ({1}:{2})", this.Name, this.IpAddress, this.Port);
        }
    }
}
