﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System;

    /// <summary>
    /// マウスボタンの定義です。
    /// </summary>
    [Flags]
    internal enum MouseButtons : uint
    {
        /// <summary>
        /// 無し
        /// </summary>
        None = 0,

        /// <summary>
        /// 左ボタン
        /// </summary>
        Left = 1u,

        /// <summary>
        /// 右ボタン
        /// </summary>
        Right = 1u << 1,

        /// <summary>
        /// 中央ボタン
        /// </summary>
        Middle = 1u << 2,

        /// <summary>
        /// フォワードボタン
        /// </summary>
        Forward = 1u << 3,

        /// <summary>
        /// バックボタン
        /// </summary>
        Back = 1u << 4,
    }
}
