﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Drawing;

    /// <summary>
    /// ゲームパッドイベントのデータを提供します。
    /// </summary>
    internal sealed class GamePadEventArgs
    {
        /// <summary>
        /// GamePadEventArgs クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="samplerId">ゲームパッドのサンプラーの識別子です。</param>
        internal GamePadEventArgs(int samplerId)
        {
            this.SamplerId = samplerId;
        }

        /// <summary>
        /// GamePadEventArgs クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="samplerId">ゲームパッドのサンプラーの識別子です。</param>
        /// <param name="name">ゲームパッドの名前です。</param>
        internal GamePadEventArgs(int samplerId, string name)
        {
            this.SamplerId = samplerId;

            this.Name = name;
        }

        /// <summary>
        /// GamePadEventArgs クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="samplerId">ゲームパッドのサンプラーの識別子です。</param>
        /// <param name="button">ゲームパッドのボタンです。</param>
        internal GamePadEventArgs(int samplerId, GamePadButtons button)
        {
            this.SamplerId = samplerId;

            this.Button = button;
        }

        /// <summary>
        /// GamePadEventArgs クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="samplerId">ゲームパッドのサンプラーの識別子です。</param>
        /// <param name="stickType">ゲームパッドのスティック種別です。</param>
        /// <param name="stick">ゲームパッドのスティック位置です。</param>
        internal GamePadEventArgs(
            int samplerId, GamePadStickType stickType, Point stick)
        {
            this.SamplerId = samplerId;

            this.StickType = stickType;

            this.Stick = stick;
        }

        /// <summary>
        /// ゲームパッドのサンプラーの識別子を取得します。
        /// </summary>
        internal int SamplerId { get; private set; }

        /// <summary>
        /// ゲームパッドの名前を取得します。
        /// </summary>
        internal string Name { get; private set; } = string.Empty;

        /// <summary>
        /// ゲームパッドのボタンを取得します。
        /// </summary>
        internal GamePadButtons Button { get; private set; }

        /// <summary>
        /// ゲームパッドのスティック種別を取得します。
        /// </summary>
        internal GamePadStickType StickType { get; private set; }

        /// <summary>
        /// ゲームパッドのスティック位置を取得します。
        /// </summary>
        internal Point Stick { get; private set; } = Point.Empty;
    }
}
