﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Windows.Forms;

    /// <summary>
    /// メインフォームです。
    /// </summary>
    internal partial class MainForm : Form
    {
        private readonly InputDirector inputDirector = new InputDirector();

        private readonly object syncObject = new object();

        private SettingsForm settingsForm = null;

        private AboutForm aboutForm = null;

        /// <summary>
        /// MainForm クラスの新しいインスタンスを初期化します。
        /// </summary>
        internal MainForm()
        {
            InitializeComponent();

            this.inputDirector.Start();

            Application.ApplicationExit +=
                new EventHandler(Application_ApplicationExit);

            this.contextMenuStrip1.Opening +=
                new CancelEventHandler(contextMenuStrip1_Opening);
        }

        private EventHandler CreateConnectClickEventHandler(
            ToolStripMenuItem item)
        {
            return new EventHandler((object sender, EventArgs e) =>
            {
                if (!item.Checked)
                {
                    this.inputDirector.StartSession(item.Text);
                }
                else
                {
                    this.inputDirector.StopSession(item.Text);
                }
            });
        }

        private void Application_ApplicationExit(object sender, EventArgs e)
        {
            this.inputDirector.Dispose();
        }

        private void contextMenuStrip1_Opening(
            object sender, CancelEventArgs e)
        {
            var items = new List<ToolStripMenuItem>();

            foreach (string name in this.inputDirector.GetSessionNames())
            {
                var item = new ToolStripMenuItem();
                item.Text = name;
                item.Checked = this.inputDirector.IsSessionConnected(name);
                item.Click += this.CreateConnectClickEventHandler(item);

                items.Add(item);
            }

            ToolStripMenuItem toolStrip = this.connectToolStripMenuItem;
            toolStrip.DropDownItems.Clear();
            toolStrip.DropDownItems.AddRange(items.ToArray());
            toolStrip.Enabled = (0 < items.Count);
        }

        private void settingsToolStripMenuItem_Click(
            object sender, EventArgs e)
        {
            SettingsForm settingsForm = null;

            lock (this.syncObject)
            {
                if (this.settingsForm != null)
                {
                    this.settingsForm.Focus();
                }
                else
                {
                    this.inputDirector.IsCaptureEnabled = false;

                    settingsForm = new SettingsForm(this.inputDirector);

                    this.settingsForm = settingsForm;
                }
            }

            if (settingsForm != null)
            {
                settingsForm.ShowDialog();

                lock (this.syncObject)
                {
                    this.settingsForm = null;

                    settingsForm.Dispose();

                    if (this.aboutForm == null)
                    {
                        this.inputDirector.IsCaptureEnabled = true;
                    }
                }
            }
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AboutForm aboutForm = null;

            lock (this.syncObject)
            {
                if (this.aboutForm != null)
                {
                    this.aboutForm.Focus();
                }
                else
                {
                    this.inputDirector.IsCaptureEnabled = false;

                    aboutForm = new AboutForm();

                    this.aboutForm = aboutForm;
                }
            }

            if (aboutForm != null)
            {
                aboutForm.ShowDialog();

                lock (this.syncObject)
                {
                    this.aboutForm = null;

                    aboutForm.Dispose();

                    if (this.settingsForm == null)
                    {
                        this.inputDirector.IsCaptureEnabled = true;
                    }
                }
            }
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.notifyIcon1.Visible = false;

            Application.Exit();
        }
    }
}
