﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector.Forms
{
    using System.Drawing;
    using System.Windows.Forms;

    /// <summary>
    /// 情報ダイアログです。
    /// </summary>
    internal sealed partial class InfoDialog : Form
    {
        private readonly InputDirector inputDirector;

        /// <summary>
        /// InfoDialog クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="inputDirector">InputDirector です。</param>
        internal InfoDialog(InputDirector inputDirector)
        {
            InitializeComponent();

            this.inputDirector = inputDirector;

            this.pictureBoxIcon.Image = new Icon(this.Icon, 48, 48).ToBitmap();

            this.LoadBorderCrossingSettings();
            this.LoadHotKeySettings();
        }

        private void LoadBorderCrossingSettings()
        {
            BorderCrossingConfig config =
                this.inputDirector.UserConfig.GetBorderCrossingConfig();

            switch (config.Border)
            {
                case BorderType.Right:
                    this.textBoxBorderType.Text =
                        Resources.Strings.InfoDialog_TVLeft;
                    break;

                case BorderType.Left:
                    this.textBoxBorderType.Text =
                        Resources.Strings.InfoDialog_TVRight;
                    break;

                case BorderType.Top:
                    this.textBoxBorderType.Text =
                        Resources.Strings.InfoDialog_TVBottom;
                    break;

                case BorderType.Bottom:
                    this.textBoxBorderType.Text =
                        Resources.Strings.InfoDialog_TVTop;
                    break;

                default:
                    break;
            }

            if (!config.IsEnabled)
            {
                this.textBoxBorderType.Text +=
                    string.Format(" ({0})", Resources.Strings.Invalid);

                this.textBoxBorderType.Enabled = false;
            }
        }

        private void LoadHotKeySettings()
        {
            HotKeyConfig config =
                this.inputDirector.UserConfig.GetHotKeyConfig();

            if (config.Modifier != Keys.None)
            {
                this.textBoxHotKey.Text = config.Modifier + " + ";
            }

            this.textBoxHotKey.Text += config.Key;

            if (!config.IsEnabled)
            {
                this.textBoxHotKey.Text +=
                    string.Format(" ({0})", Resources.Strings.Invalid);

                this.textBoxHotKey.Enabled = false;
            }
        }
    }
}
