﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace InputCapture.Windows.Forms
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;

    public partial class InfoDialog : Form
    {
        public InfoDialog(UserSettings userSettings)
        {
            InitializeComponent();

            Icon icon = new Icon(this.Icon, 48, 48);
            this.pictureBoxIcon.Image = icon.ToBitmap();

            {
                switch (userSettings.CaptureBorderType)
                {
                    case BorderType.Right:
                        this.textBoxBorderType.Text = Resources.Strings.InfoDialog_TVLeft;
                        break;
                    case BorderType.Left:
                        this.textBoxBorderType.Text = Resources.Strings.InfoDialog_TVRight;
                        break;
                    case BorderType.Top:
                        this.textBoxBorderType.Text = Resources.Strings.InfoDialog_TVBottom;
                        break;
                    case BorderType.Bottom:
                        this.textBoxBorderType.Text = Resources.Strings.InfoDialog_TVTop;
                        break;
                    default:
                        break;
                }

                if (!userSettings.IsCaptureOnMousePosition)
                {
                    this.textBoxBorderType.Text += string.Format(" ({0})", Resources.Strings.Invalid);
                    this.textBoxBorderType.Enabled = false;
                }
            }

            {
                if (userSettings.HotKeyModifier != Keys.None)
                {
                    this.textBoxHotKey.Text = userSettings.HotKeyModifier + " + ";
                }

                this.textBoxHotKey.Text += userSettings.HotKey;

                if (!userSettings.IsCaptureOnHotKey)
                {
                    this.textBoxHotKey.Text += string.Format(" ({0})", Resources.Strings.Invalid);
                    this.textBoxHotKey.Enabled = false;
                }
            }
        }
    }
}
