﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_ShaderCompilerDll.h>

namespace nn {
namespace gfxTool {

bool ShaderCompilerDll::Initialize( const char* pDllPath )
{
    if( !DllBase::Initialize( pDllPath ) )
    {
        return false;
    }

    CreateHandle = GetRequiredFunction< decltype( CreateHandle ) >( "nngfxToolShaderCompilerCreateHandle" );
    ResetHandle = GetRequiredFunction< decltype( ResetHandle ) >( "nngfxToolShaderCompilerResetHandle" );
    Compile = GetRequiredFunction< decltype( Compile ) >( "nngfxToolShaderCompilerCompile" );
    DeleteHandle = GetRequiredFunction< decltype( DeleteHandle ) >( "nngfxToolShaderCompilerDeleteHandle" );
    DeleteCompileOutput = GetRequiredFunction< decltype( DeleteCompileOutput ) >( "nngfxToolShaderCompilerDeleteCompileOutput" );
    SetLogStream = GetFunction< decltype( SetLogStream ) >( "nngfxToolShaderCompilerSetLogStream" );
    GetApiVersion = GetFunction< decltype( GetApiVersion ) >( "nngfxToolShaderCompilerGetApiVersion" );

    if( SetLogStream )
    {
        nngfxToolSetLogStreamArg arg = {};
        for( int idxLogType = 0; idxLogType < nngfxToolLogType_End; ++idxLogType )
        {
            arg.logType = NumericCastAuto( idxLogType );
            arg.hLogStream = Logger::GetStream( StaticCastAuto( idxLogType ) );
            SetLogStream( &arg );
        }
    }

    if( GetApiVersion )
    {
        nngfxToolApiVersion apiVersion = {};
        if( GetApiVersion( &apiVersion ) == nngfxToolResultCode_Succeeded )
        {
            if( apiVersion.major != nngfxToolShaderCompilerVersion_Major ||
                apiVersion.minor < nngfxToolShaderCompilerVersion_Minor )
            {
                NN_GFXTOOL_THROW_MSG( nngfxToolResultCode_InvalidApiVersion,
                    "ShaderCompiler version mismatch:\n"
                    "    expected: %d.>=%d.*\n"
                    "    actual: %d.%d.%d\n",
                    nngfxToolShaderCompilerVersion_Major,
                    nngfxToolShaderCompilerVersion_Minor,
                    apiVersion.major,
                    apiVersion.minor,
                    apiVersion.micro );
            }
        }
    }

    return true;
}

}
}
