﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfx/gfx_ResShaderData.h>

#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_ResShaderVariationBinarizer.h>
#include <gfxTool_ResShaderProgramBinarizer.h>
#include <gfxTool_ShaderBinarizerContext.h>
#include <gfxTool_ResShaderContainerBinarizer.h>

namespace nn {
namespace gfxTool {

ResShaderVariationBinarizer::ResShaderVariationBinarizer()
    : m_pTarget()
    , m_pParent()
{
}

ResShaderVariationBinarizer::~ResShaderVariationBinarizer() = default;

template< typename TFunc >
void ResShaderVariationBinarizer::ForEachProgram( TFunc func )
{
    if( m_pSourceProgram.get() )
    {
        func( m_pSourceProgram.get() );
    }
    if( m_pIntermediateLanguageProgram.get() )
    {
        func( m_pIntermediateLanguageProgram.get() );
    }
    if( m_pBinaryProgram.get() )
    {
        func( m_pBinaryProgram.get() );
    }
}

void ResShaderVariationBinarizer::Initialize( const BinarizationTarget* pTarget,
    const ResShaderContainerBinarizer* pParent, int idxVariation )
{
    m_pTarget = pTarget;
    m_pParent = pParent;

    if( pTarget->pSourceOutput )
    {
        m_pSourceProgram.reset( new ResShaderProgramBinarizer() );
        m_pSourceProgram->Initialize( pTarget->pSourceOutput, this );
    }
    if( pTarget->pIntermediateLanguageOutput )
    {
        m_pIntermediateLanguageProgram.reset( new ResShaderProgramBinarizer() );
        m_pIntermediateLanguageProgram->Initialize( pTarget->pIntermediateLanguageOutput, this );
    }
    if( pTarget->pBinaryOutput )
    {
        m_pBinaryProgram.reset( new ResShaderProgramBinarizer() );
        m_pBinaryProgram->Initialize( pTarget->pBinaryOutput, this );
    }
    m_IdxVariation = idxVariation;
}

void ResShaderVariationBinarizer::RegisterChild( ShaderBinarizerContext* pContext )
{
    ForEachProgram( [ pContext ]( ResShaderProgramBinarizer* pProgram ) {
        pContext->AddMemoryBlock( StaticCastAuto( Section::Common ), pProgram ); } );
    ForEachProgram( [ pContext ]( ResShaderProgramBinarizer* pProgram ) {
        pProgram->RegisterChild( pContext ); } );
}

void ResShaderVariationBinarizer::CalculateSize()
{
    SetSizeBy< ResTarget >();
}

void ResShaderVariationBinarizer::Link( ShaderBinarizerContext* pContext )
{
    ResTarget* pResTarget = nullptr;

    pContext->LinkPtr( this, &pResTarget->pParent, GetParent() );

    pContext->LinkPtr( this, &pResTarget->pSourceProgram, m_pSourceProgram.get() );

    pContext->LinkPtr( this, &pResTarget->pIntermediateLanguageProgram,
        m_pIntermediateLanguageProgram.get() );

    pContext->LinkPtr( this, &pResTarget->pBinaryProgram, m_pBinaryProgram.get() );
}

void ResShaderVariationBinarizer::Convert( ShaderBinarizerContext* )
{
}

}
}
