﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <functional>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

struct CommandLineArg;

class WriteFileCallback
{
public:
    static std::function< bool ( const void*, size_t, const char*, void* ) > GetCallback()
    {
        return []( const void* pFileData, size_t fileDataSize, const char* pFilename, void* pParam ) {
            return Callback( pFileData, fileDataSize, pFilename, pParam ); };
    }

    static bool Callback( const void* pFileData, size_t fileDataSize,
        const char* pFilename, void* pParam );

    void SetCallback( nngfxToolWriteFileCallback pCallback, void* pCallbackParam )
    {
        m_pCallback = pCallback;
        m_pCallbackParam = pCallbackParam;
    }

    void SetDirectory( const char* directory );

private:
    nngfxToolWriteFileCallback m_pCallback;
    void* m_pCallbackParam;

    Custom< std::string >::Type m_Directory;
};

}
}
