﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfx/gfx_ResShaderData.h>

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class ShaderReflectionStageBinarizer
    : public BinarizerBase
{
public:
    typedef nn::gfx::ResShaderReflectionStageData ResTarget;
    typedef nn::gfx::ResShaderReflectionStageData2 ResTarget2;
    typedef nngfxToolShaderCompilerShaderReflection BinarizationTarget;

    void Initialize( const BinarizationTarget* pTarget, ShaderStage stage );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    bool IsEmpty() const
    {
        return m_SlotCount <= 0;
    }

private:
    bool IsData2Needed( const BinarizationTarget* pTarget ) const;

    const BinarizationTarget* m_pTarget;
    ShaderStage m_Stage;

    Custom< std::vector< const nngfxToolShaderCompilerShaderInput* > >::Type m_ShaderInputs;
    Custom< std::vector< const nngfxToolShaderCompilerShaderOutput* > >::Type m_ShaderOutputs;
    Custom< std::vector< const nngfxToolShaderCompilerSampler* > >::Type m_Samplers;
    Custom< std::vector< const nngfxToolShaderCompilerConstantBuffer* > >::Type m_ConstantBuffers;
    Custom< std::vector< const nngfxToolShaderCompilerUnorderedAccessBuffer* > >::Type m_UnorderedAccessBuffers;
    Custom< std::vector< const nngfxToolShaderCompilerImage* > >::Type m_Images;
    Custom< std::vector< const nngfxToolShaderCompilerSeparateTexture* > >::Type m_SeparateTextures;
    Custom< std::vector< const nngfxToolShaderCompilerSeparateSampler* > >::Type m_SeparateSamplers;
    int m_SlotCount;

    nn::util::MemorySplitter::MemoryBlock m_ShaderInputDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_ShaderOutputDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_SamplerDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_ConstantBufferDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_UnorderedAccessBufferDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_ImageDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_SeparateTextureDicBlock;
    nn::util::MemorySplitter::MemoryBlock m_SeparateSamplerDicBlock;

    nn::util::MemorySplitter::MemoryBlock m_SlotBlock;

    nn::util::MemorySplitter::MemoryBlock m_Data2Block;
};

class ShaderReflectionBinarizer
    : public BinarizerBase
{
public:
    typedef nn::gfx::ResShaderReflectionData ResTarget;
    typedef nngfxToolShaderCompilerShaderReflection BinarizationTarget;

    void Initialize( const BinarizationTarget* pTarget );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

private:
    const BinarizationTarget* m_pTarget;

    ShaderReflectionStageBinarizer m_ReflectionStages[ static_cast< int >( ShaderStage::End ) ];
};

}
}
