﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class ShaderBinarizerContext;
class ResShaderVariationBinarizer;
class ShaderCodeBinarizerBase;
class ShaderReflectionBinarizer;
class FullReflectionBinarizer;

class ResShaderProgramBinarizer
    : public BinarizerBase
{
public:
    typedef nn::gfx::ResShaderProgramData ResTarget;
    typedef nngfxToolShaderCompilerShaderProgramOutput BinarizationTarget;

    ResShaderProgramBinarizer();

    ~ResShaderProgramBinarizer();

    void Initialize( const BinarizationTarget* pTarget, const ResShaderVariationBinarizer* pParent );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    const ResShaderVariationBinarizer* GetParent() const
    {
        return m_pParent;
    }

    void MergeCode( ShaderStage stage, int targetVariation )
    {
        m_MergeCode[ static_cast< int >( stage ) ] = targetVariation;
    }

    const nn::gfx::ShaderInfoData* GetInfoData() const
    {
        return StaticCastAuto( m_pTarget->nngfxShaderInfoData );
    }

    template< typename T >
    const T* GetShaderCodeBinarizer( ShaderStage stage ) const
    {
        return StaticCastAuto( m_pCodeBinarizer[ static_cast< int >( stage ) ].get() );
    }

    template< typename T >
    T* GetShaderCodeBinarizer( ShaderStage stage )
    {
        return StaticCastAuto( m_pCodeBinarizer[ static_cast< int >( stage ) ].get() );
    }

    const ShaderCodeBinarizerBase* GetShaderCodeBinarizer( ShaderStage stage ) const
    {
        return m_pCodeBinarizer[ static_cast< int >( stage ) ].get();
    }

private:
    const BinarizationTarget* m_pTarget;
    const ResShaderVariationBinarizer* m_pParent;

    nn::util::MemorySplitter::MemoryBlock m_Obj;
    int m_MergeCode[ static_cast< int >( ShaderStage::End ) ];

    Custom< std::unique_ptr< ShaderCodeBinarizerBase > >::Type
        m_pCodeBinarizer[ static_cast< int >( ShaderStage::End ) ];
    Custom< std::unique_ptr< ShaderReflectionBinarizer > >::Type m_pReflectionBinarizer;
    Custom< std::unique_ptr< FullReflectionBinarizer > >::Type m_pFullReflectionBinarizer;
};

}
}
