﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>
#include <functional>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

struct CommandLineArg;

class ReadFileCallback
{
public:
    static std::function< bool ( void**, size_t*, const char*, void* ) > GetCallback()
    {
        return []( void** ppOutFileData, size_t* pOutFileDataSize, const char* pFileName, void* pParam ) {
            return Callback( ppOutFileData, pOutFileDataSize, pFileName, pParam ); };
    }

    static bool Callback( void** ppOutFileData, size_t* pOutFileDataSize,
        const char* pFileName, void* pParam );

    void SetCallback( nngfxToolReadFileCallback pCallback, void* pCallbackParam )
    {
        m_pCallback = pCallback;
        m_pCallbackParam = pCallbackParam;
    }

    void AddDirectory( const char* directory );

private:
    nngfxToolReadFileCallback m_pCallback;
    void* m_pCallbackParam;

    Custom< std::vector< Custom< std::string >::Type > >::Type m_Directories;
};

}
}
