﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class FullReflectionBinarizer
    : public BinarizerBase
{
public:
    typedef nngfxToolShaderCompilerShaderReflection ResTarget;
    typedef nngfxToolShaderCompilerShaderReflection BinarizationTarget;

    void Initialize( const BinarizationTarget* pTarget );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;

private:
    enum class ReflectionType
    {
        ConstantBuffer,
        UnorderedAccessBuffer,
        Input,
        Output,
        Sampler,
        ConstantBufferVariable,
        UnorderedAccessBufferVariable,
        Image,
        SeparateTexture,
        SeparateSampler,

        End
    };

    template< ReflectionType reflectionType >
    struct ReflectionTypeType;

    const BinarizationTarget* m_pTarget;

    Custom< std::vector< nn::util::MemorySplitter::MemoryBlock > >::Type
        m_ReflectionBlocks[ static_cast< int >( ReflectionType::End ) ];

    template< typename Func >
    void ForEachReflections( Func func );
};

}
}
