﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class CompileArg;
class CreateConvertArgOutput;
struct CommandLineArg;

class ConvertArg
    : public nngfxToolShaderConverterConvertArg
{
public:
    typedef ConvertArg SelfType;

    ConvertArg();

    ~ConvertArg();

    static ConvertArg* Create()
    {
        return new ConvertArg();
    }

    static nngfxToolResultCode Delete( ConvertArg* ptr )
    {
        if( ptr == nullptr )
        {
            return nngfxToolResultCode_InvalidHandle;
        }
        delete ptr;
        return nngfxToolResultCode_Succeeded;
    }

    static SelfType* DownCast( nngfxToolShaderConverterConvertArg* pArg )
    {
        return StaticCastAuto( pArg );
    }

    nngfxToolResultCode Initilaize( const nngfxToolShaderConverterCreateConvertArgArg* pArg );

private:
    Custom< std::unique_ptr< CompileArg > >::Type m_pCompileArg;

    Custom< std::string >::Type m_Name;

    Custom< std::unique_ptr< CreateConvertArgOutput > >::Type m_pCreateConvertArgOutput;

    Custom< std::vector< const void* > >::Type m_MergeShaderFiles;
};

}
}
