﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_ProgramOutput.h>
#include <gfxTool_OptionOutput.h>

namespace nn {
namespace gfxTool {

ProgramOutput::ProgramOutput()
    : nngfxToolShaderCompilerShaderProgramOutput()
    , m_Info()
{
}

ProgramOutput::~ProgramOutput()
{
}

void ProgramOutput::Initialize( const nngfxToolShaderCompilerCompileArg* )
{
    this->nngfxShaderInfoData = &m_Info;

    this->optionOutputCount = 0;
    this->pOptionOutputArray = nullptr;
}

void ProgramOutput::SetCode( ShaderStage stage, std::shared_ptr< void > pCode )
{
    auto idxStage = static_cast< int >( stage );
    m_pCode[ idxStage ] = pCode;
    *GetStageCodePtr( &m_Info, stage ) = m_pCode[ idxStage ].get();
}

void ProgramOutput::SetShaderCode( ShaderStage stage, std::shared_ptr< void > pCode, size_t codeSize )
{
    return SetShaderCode( stage, pCode, codeSize, 0 );
}

void ProgramOutput::SetShaderCode( ShaderStage stage,
    std::shared_ptr< void > pCode, size_t codeSize, size_t decompressedCodeSize )
{
    auto idxStage = static_cast< int >( stage );
    m_pCode[ idxStage ] = pCode;
    m_ShaderCode[ idxStage ].pCode = m_pCode[ idxStage ].get();
    m_ShaderCode[ idxStage ].codeSize = StaticCastAuto( codeSize );
    m_ShaderCode[ idxStage ].decompressedCodeSize = StaticCastAuto( decompressedCodeSize );
    *GetStageCodePtr( &m_Info, stage ) = m_ShaderCode + idxStage;
}

void ProgramOutput::SetSourceArrayCode( ShaderStage stage,
    std::shared_ptr< SourceArrayOutput > pSourceArray )
{
    auto idxStage = static_cast< int >( stage );
    m_pSourceArrayOutput[ idxStage ] = pSourceArray;
    *GetStageCodePtr( &m_Info, stage ) = m_SourceArrayCode + idxStage;
    m_SourceArrayCode[ idxStage ].codeArrayLength = NumericCastAuto(
        m_pSourceArrayOutput[ idxStage ]->codeArray.size() );
    m_SourceArrayCode[ idxStage ].pCodeSizeArray =
        &m_pSourceArrayOutput[ idxStage ]->codeSizeArray[ 0 ];
    m_SourceArrayCode[ idxStage ].pCodePtrArray = reinterpret_cast< nn::gfx::detail::Ptr<
        const void >* >( &m_pSourceArrayOutput[ idxStage ]->codeArray[ 0 ] );
}

void ProgramOutput::AddOptionOutput(
    nngfxToolShaderCompilerOptionOutputType type, std::shared_ptr< void > pOutput )
{
    m_Options.push_back( pOutput );
    m_OptionOutputArrayRaw.emplace_back();
    m_OptionOutputArrayRaw.back().optionOutputType = StaticCastAuto( type );
    m_OptionOutputArrayRaw.back().pOutput = pOutput.get();
    this->optionOutputCount = NumericCastAuto( m_OptionOutputArrayRaw.size() );
    this->pOptionOutputArray = &m_OptionOutputArrayRaw[ 0 ];
}

void* ProgramOutput::GetOptionOutput( nngfxToolShaderCompilerOptionOutputType type )
{
    auto found = std::find_if( m_OptionOutputArrayRaw.begin(), m_OptionOutputArrayRaw.end(),
        [ & ]( decltype( *m_OptionOutputArrayRaw.begin() )& option )
    {
        return option.optionOutputType == static_cast< decltype( option.optionOutputType ) >( type );
    } );
    return found == m_OptionOutputArrayRaw.end() ?
        nullptr : m_Options[ std::distance( m_OptionOutputArrayRaw.begin(), found ) ].get();
}

}
}
