﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_GroupSource.h>

namespace nn {
namespace gfxTool {

void PreprocessorDefinitionSource::Initialize( const nngfxToolShaderCompilerCompileArg* pArg,
    const Custom< std::vector< int > >::Type* pGroupToHeadVariationTable, ShaderStage stage )
{
    if( pGroupToHeadVariationTable == nullptr )
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InternalError );
    }

    m_Sources.resize( pGroupToHeadVariationTable->size() );

    if( pArg->pVariationDefinitionArg == nullptr )
    {
        return;
    }

    auto pVariationDefinition = GetStageVariationDefinition( pArg->pVariationDefinitionArg, stage );

    for( int idxGroup = 0, groupCount = NumericCastAuto(
        pGroupToHeadVariationTable->size() ); idxGroup < groupCount; ++idxGroup )
    {
        auto& dst = m_Sources[ idxGroup ];
        auto pStageVariationValue = GetStageVariationValue( pArg->pVariationValueArray +
            ( *pGroupToHeadVariationTable )[ idxGroup ], stage );
        if( pStageVariationValue == nullptr )
        {
            continue;
        }
        auto pValues = pStageVariationValue->pPreprocessorDefinitionValueArray;
        if( pValues == nullptr )
        {
            continue;
        }
        for( int idxMacro = 0, macroCount = NumericCastAuto(
            pVariationDefinition->preprocessorDefinitionDefinitionCount ); idxMacro < macroCount; ++idxMacro )
        {
            auto& definition = pVariationDefinition->pPreprocessorDefinitionDefinitionArray[ idxMacro ];
            dst.append( "#define " );
            dst.append( definition.name.pValue, definition.name.length );
            dst.append( " " );
            auto& value = pValues[ definition.indexInPreprocessorDefinitionValueArray ];
            dst.append( value.pValue, value.length );
            dst.append( "\n" );
        }
    }
}

}
}
