﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#ifndef WIN32_LEAN_AND_MEAN
#define WIN32_LEAN_AND_MEAN
#endif
#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_GlContext.h>
#include <gfxTool_Common.h>

#define WGL_CONTEXT_MAJOR_VERSION_ARB 0x2091 // NOLINT
#define WGL_CONTEXT_MINOR_VERSION_ARB 0x2092 // NOLINT
#define WGL_CONTEXT_FLAGS_ARB 0x2094 // NOLINT
#define WGL_CONTEXT_PROFILE_MASK_ARB 0x9126 // NOLINT
#define WGL_CONTEXT_CORE_PROFILE_BIT_ARB 0x00000001 // NOLINT
#define WGL_CONTEXT_DEBUG_BIT_ARB 0x0001 // NOLINT

namespace nn {
namespace gfxTool {

namespace {

typedef HGLRC (WINAPI* PFNWGLCREATECONTEXTATTRIBSARBPROC)
    ( HDC hDc, HGLRC hShareContext, const int* attribList );

int SetPixelFormat( HDC hDc ) NN_NOEXCEPT
{
    PIXELFORMATDESCRIPTOR pfd =
    {
        sizeof( PIXELFORMATDESCRIPTOR ),
        1,
        PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER, // フラグ
        PFD_TYPE_RGBA, // フレームバッファタイプ
        24, // フレームバッファのカラービット幅
        0, 0, 0, 0, 0, 0,
        0,
        0,
        0,
        0, 0, 0, 0,
        0, // 深度バッファのビット幅
        0, // ステンシルバッファのビット幅
        0,
        PFD_MAIN_PLANE,
        0,
        0, 0, 0
    };

    auto pixelFormat = ::GetPixelFormat( hDc );
    if( pixelFormat == 0 )
    {
        pixelFormat = ::ChoosePixelFormat( hDc, &pfd );
        if( pixelFormat )
        {
            if( ::SetPixelFormat( hDc, pixelFormat, &pfd ) )
            {
                return pixelFormat;
            }
        }

        return 0;
    }

    return pixelFormat;
}

HGLRC CreateGlRc( HDC hDc, HGLRC hSharedRc, int majorVersion, bool debugMode ) NN_NOEXCEPT
{
    if( !SetPixelFormat( hDc ) )
    {
        return NULL;
    }

    auto hRc = ::wglCreateContext( hDc );
    if( hRc == NULL )
    {
        return NULL;
    }

    int flag = debugMode ? WGL_CONTEXT_DEBUG_BIT_ARB : 0;
    int attribs[] =
    {
        WGL_CONTEXT_MAJOR_VERSION_ARB, majorVersion,
        WGL_CONTEXT_MINOR_VERSION_ARB, 0,
        WGL_CONTEXT_FLAGS_ARB, flag,
        WGL_CONTEXT_PROFILE_MASK_ARB, WGL_CONTEXT_CORE_PROFILE_BIT_ARB,
        0
    };

    ::wglMakeCurrent( hDc, hRc );
    const PFNWGLCREATECONTEXTATTRIBSARBPROC wglCreateContextAttribsARB =
        (PFNWGLCREATECONTEXTATTRIBSARBPROC)wglGetProcAddress( "wglCreateContextAttribsARB" );
    if( wglCreateContextAttribsARB )
    {
        auto hNewRc = wglCreateContextAttribsARB( hDc, hSharedRc, attribs );
        if( hNewRc )
        {
            ::wglMakeCurrent( NULL, NULL );
            ::wglDeleteContext( hRc );
            return hNewRc;
        }
    }

    ::wglMakeCurrent( NULL, NULL );
    if( hSharedRc )
    {
        ::wglShareLists( hSharedRc, hRc );
    }

    return hRc;
}

}

GlContext::~GlContext()
{
    m_hDc = nullptr;
    if( m_hGlRc )
    {
        ::wglMakeCurrent( nullptr, nullptr );
        ::wglDeleteContext( m_hGlRc );
    }
}

void GlContext::Initialize( HDC hDc, HGLRC hSharedRc )
{
    if( ( m_hGlRc = CreateGlRc( hDc, hSharedRc, 4, false ) ) == nullptr )
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_FailedToCreateGlContext );
    }
    m_hDc = hDc;
}

void GlContext::MakeCurrent() const
{
    if( ::wglMakeCurrent( m_hDc, m_hGlRc ) == FALSE )
    {
        NN_GFXTOOL_THROW_MSG( nngfxToolResultCode_Failed, "%s", GetLastErrorString().c_str() );
    }
}

}
}
