﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_CompileOptionManager.h>
#include <gfxTool_CompileOption-glsl.h>
#include <gfxTool_CompileOption-gx.h>
#include <gfxTool_CompileOption-nvn.h>
#include <gfxTool_CompileOption-vk.h>

namespace nn {
namespace gfxTool {

CompileOptionManager::CompileOptionManager()
{
}

CompileOptionManager::~CompileOptionManager()
{
}

void CompileOptionManager::Initialize( const nngfxToolShaderCompilerCompileArg* pArg )
{
    m_pCompileOptions[ nngfxToolShaderCompilerOptionType_Common ].reset(
        new CompileOption< nngfxToolShaderCompilerOptionType_Common >() );
    m_pCompileOptions[ nngfxToolShaderCompilerOptionType_Glsl ].reset(
        new CompileOption< nngfxToolShaderCompilerOptionType_Glsl >() );
    m_pCompileOptions[ nngfxToolShaderCompilerOptionType_Gx ].reset(
        new CompileOption< static_cast< nngfxToolShaderCompilerOptionType >(
        nngfxToolShaderCompilerOptionType_Gx ) >() );
    m_pCompileOptions[ nngfxToolShaderCompilerOptionType_Nvn ].reset(
        new CompileOption< static_cast< nngfxToolShaderCompilerOptionType >(
        nngfxToolShaderCompilerOptionType_Nvn ) >() );
    m_pCompileOptions[ nngfxToolShaderCompilerOptionType_Vk ].reset(
        new CompileOption< static_cast< nngfxToolShaderCompilerOptionType >(
        nngfxToolShaderCompilerOptionType_Vk ) >() );


    for( int idxOption = 0, optionCount = NumericCastAuto( pArg->optionCount );
        idxOption < optionCount; ++idxOption )
    {
        auto& option = pArg->pOptionArray[ idxOption ];
        m_pCompileOptions[ option.optionType ].get()->Initialize( option.pOption );
    }
}

}
}
