﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <gfxTool_CompileOption-glsl.h>

namespace nn {
namespace gfxTool {

void CompileOption< nngfxToolShaderCompilerOptionType_Glsl >::Initialize( const void* pOption )
{
    auto& option = *static_cast< const nngfxToolShaderCompilerCompileOptionGlsl* >( pOption );
    m_pGlslHeader.reset( new Custom< std::string >::Type() );

    if( option.glslVersion.pValue )
    {
        if( option.glslVersion.pValue[ 0 ] != '#' )
        {
            m_pGlslHeader->append( "#version " );
        }
        m_pGlslHeader->append( option.glslVersion.pValue, option.glslVersion.length );
        m_pGlslHeader->append( "\n" );
    }

    std::for_each( option.pGlslExtensionArray, option.pGlslExtensionArray + option.glslExtensionCount,
        [ & ]( decltype( *option.pGlslExtensionArray )& glslExtension ) { m_pGlslHeader->append(
            "#extension ").append( glslExtension.pValue, glslExtension.length ).append( "\n" ); } );
}

}
}
