﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_Common.h>

struct nngfxToolShaderCompilerCompileArg;

namespace nn {
namespace gfxTool {

class VariationGrouper
{
public:
    typedef bool ( *LessVariation )( const nngfxToolShaderCompilerVariationDefinition* definition,
        const nngfxToolShaderCompilerVariationValue* lhs, const nngfxToolShaderCompilerVariationValue* rhs );

    void Initialize( const nngfxToolShaderCompilerCompileArg* pArg, LessVariation pred, ShaderStage stage );
    void Intersect( const Custom< std::vector< const VariationGrouper* > >::Type& grouperArray );

    int VariationToHeadVaritaion( int idxVariation ) const
    {
        if( idxVariation > NumericCast< decltype( idxVariation ) >( m_VariationToGroup.size() ) )
        {
            NN_GFXTOOL_THROW( nngfxToolResultCode_InternalError );
        }
        return m_GroupToHeadVariation[ m_VariationToGroup[ idxVariation ] ];
    }

    int GetGroupCount() const
    {
        return StaticCastAuto( m_GroupToHeadVariation.size() );
    }

    const Custom< std::vector< int > >::Type& GetVariationToGroupTable() const
    {
        return m_VariationToGroup;
    }

    const Custom< std::vector< int > >::Type& GetGroupToHeadVariationTable() const
    {
        return m_GroupToHeadVariation;
    }

    static bool LessConstantValue( const nngfxToolShaderCompilerVariationDefinition* definition,
        const nngfxToolShaderCompilerVariationValue* lhs, const nngfxToolShaderCompilerVariationValue* rhs );
    static bool LessPreprocessorDefinition( const nngfxToolShaderCompilerVariationDefinition* definition,
        const nngfxToolShaderCompilerVariationValue* lhs, const nngfxToolShaderCompilerVariationValue* rhs );

private:
    Custom< std::vector< int > >::Type m_VariationToGroup;
    Custom< std::vector< int > >::Type m_GroupToHeadVariation;
};

}
}
