﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_Compiler.h>
#include <gfxTool_NvnGlslcDll.h>

namespace nn {
namespace gfxTool {

class ProgramOutput;
class OptionOutputReflection;
class CompileObject;

template<>
class Compiler< CompilerVariation< static_cast<
    nngfxToolShaderCompilerLowLevelApiType >( nngfxToolShaderCompilerLowLevelApiType_Nvn ),
    nngfxToolShaderCompilerCodeType_Binary > >
    : public CompilerBase
{
public:
    Compiler();
    ~Compiler();

    virtual int GetGroupCount( const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg ) const override;

    virtual void PreCompile( CompileOutput* pOutput,
        const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg ) override;

    virtual void CompileGroup( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg, int idxGroup ) override;

    virtual void PostCompile( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg ) override;

private:
    NvnGlslcDll m_NvnGlslcDll;
    Custom< std::unique_ptr< CompileObject[] > >::Type m_CompileObjects;
};

}
}
