﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_Compiler.h>

namespace nn {
namespace gfxTool {

class ProgramOutput;
struct SourceArrayOutput;

template<>
class Compiler< CompilerVariation< nngfxToolShaderCompilerLowLevelApiType_Gl,
    nngfxToolShaderCompilerCodeType_Source > >
    : public CompilerBase
{
public:
    virtual int GetGroupCount( const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg ) const override
    {
        NN_UNUSED( pContext );
        return pArg->variationCount;
    }

    virtual void PreCompile( CompileOutput* pOutput,
        const ShaderCompilerContext* pContext, const nngfxToolShaderCompilerCompileArg* pArg ) override;

    virtual void CompileGroup( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg, int idxGroup ) override;

private:
    void DumpShaderSource( ProgramOutput* pOutput,
        const SourceArrayOutput& sourceArray, ShaderStage stage );
};

}
}
