﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "gfxTool_HlslCrossCompilerOptionParser.h"

namespace nn {
namespace gfxTool {


HlslShaderCompilerOptionParser::HlslShaderCompilerOptionParser()
{
    SetArgs( &m_InputArgArray );
    SetOption( m_OptionDefinitions.version.Define( false, "version", "Display version information and exit." ) );
    SetOption( m_OptionDefinitions.help.Define( false, 'h', "help", "Display this help and exit." ) );
    SetOption( m_OptionDefinitions.silent.Define( false, "silent", "Don't display progress infomation." ) );
    SetOption( m_OptionDefinitions.output.Define( false, 'o', "output", "Specifies the output file name." ) );
    //SetOption( m_OptionDefinitions.reflection.Define( false, "reflection", "Output reflections." ) );
    SetOption( m_OptionDefinitions.hlslccOptionFlags.Define( false, "hlslcc-option-flags", "Specifies hlslcc option flags." ) );
    SetOption( m_OptionDefinitions.hlslCompileOptionFlags.Define( false, "hlsl-compile-option-flags", "Specifies hlsl compile option flags." ) );
    SetOption( m_OptionDefinitions.entryPoint.Define( false, "entry-point", "Specifies the name of entry point." ) );
    SetOption( m_OptionDefinitions.shaderModel.Define( true, "shader-model", "Specifies shader model." ) );
    SetOption( m_OptionDefinitions.preprocessorDefinitions.Define( false, "preprocessor-definition", "Adds a preprocessor definition." ) );
    SetOption( m_OptionDefinitions.includeDirectories.Define( false, "include-directory", "Adds include directory." ) );
    SetOption( m_OptionDefinitions.systemBufferBinding.Define( false, "system-buffer-binding", "Internal use specifies system buffer binding." ) );
    SetOption( m_OptionDefinitions.shiftPatchLocation.Define( false, "shift-patch-location", "Shifts patch location." ) );
}

}
}
