/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#version 330

in Raster
{
    vec3 normal;
    vec4 color;
    vec2 uv;
} IN;

uniform sampler2D albedoTex;

layout(std140) uniform Material
{
    vec3 offset;
};

void main()
{
    vec4 albedo = texture(albedoTex, IN.uv);
    gl_FragData[0] = albedo * IN.color;
    gl_FragData[0].rgb += offset;

    gl_FragData[1] = vec4(IN.normal, 0);

//    float rim = IN.color.a;
//    gl_FragColor.rgb = albedo.rgb * IN.color.rgb;
//    gl_FragColor.rgb += vec3(rim, rim, rim);
//    gl_FragColor.rgb += offset;
//    gl_FragColor.a = albedo.a;
}
