﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cassert>
#include <chrono>
#include <iostream>
#include <Windows.h>
#include <autoTestAssistTool/HidInputerTypes.h>

#include "ControllerException.h"
#include "TouchException.h"

#ifdef _DEBUG
#define ERRMSG(x)   (std::cout << (std::string("ERROR : ")+ x).c_str() << std::endl);
#else
#define ERRMSG(x)
#endif

// エラーメッセージ
#define UNEXPECTED_EXCEPTION_MESSAGE        (std::string("Invalid exception was occured."))
#define UNEXPECTED_HID_TASK_EXCUTED_MESSAGE (std::string("Unexpected task was executed."))
#define UNEXPECTED_HID_TASK_EXPORT_MESSAGE  (std::string("Unexpected task was exported."))




enum HidTaskType : int32_t
{
    // Xpad
    HidTaskType_SetXpadConnection,
    HidTaskType_SetXpadButtonState,
    HidTaskType_SetXpadPressButton,
    HidTaskType_SetXpadReleaseButton,
    HidTaskType_SetXpadStickLX,
    HidTaskType_SetXpadStickLY,
    HidTaskType_SetXpadStickRX,
    HidTaskType_SetXpadStickRY,

    // Debug pad
    HidTaskType_SetDebugPadConnection,
    HidTaskType_SetDebugPadButtonState,
    HidTaskType_SetDebugPadPressButton,
    HidTaskType_SetDebugPadReleaseButton,
    HidTaskType_SetDebugPadStickLX,
    HidTaskType_SetDebugPadStickLY,
    HidTaskType_SetDebugPadStickRX,
    HidTaskType_SetDebugPadStickRY,

    // Capture Button
    HidTaskType_SetCaptureButton,

    // Home Button
    HidTaskType_SetHomeButton,

    // Touch Screen
    HidTaskType_SetFingerId,
    HidTaskType_SetTouchState,
    HidTaskType_TouchScreen_X,
    HidTaskType_TouchScreen_Y,
    HidTaskType_MoveTouchPoint_X,
    HidTaskType_MoveTouchPoint_Y,

    // AbstractedPad
    HidTaskType_SetVirtualPadDeviceType,
    HidTaskType_SetVirtualPadInterfaceType,
    HidTaskType_SetVirtualPadMainColor,
    HidTaskType_SetVirtualPadSubColor,
    HidTaskType_SetVirtualPadConnection,
    HidTaskType_SetVirtualPadButtonState,
    HidTaskType_SetVirtualPadPressButton,
    HidTaskType_SetVirtualPadReleaseButton,
    HidTaskType_SetVirtualPadStickLX,
    HidTaskType_SetVirtualPadStickLY,
    HidTaskType_SetVirtualPadStickRX,
    HidTaskType_SetVirtualPadStickRY,
};

struct HidTask
{
    int32_t         id;
    int32_t         value;
    HidTaskType     taskType;
};

struct HidTaskRecord
{
    std::chrono::system_clock::time_point   timestamp;
    int32_t                                 id;
    int32_t                                 value;
    HidTaskType                             taskType;
};

// コントローラーのデバイス色
struct ControllerColor
{
    int red;
    int green;
    int blue;
};
