﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "IoPortSender.h"
#include "PadInputer.h"

class VirtualPadInputer : public PadInputer
{
public:
    VirtualPadInputer(IoPortSender* sender, int controllerId,
        ControllerDeviceType deviceType, ControllerInterfaceType interfaceType,
        ControllerColor mainColor, ControllerColor subColor);
    virtual ~VirtualPadInputer();

    void BeginAutoPilot();
    void EndAutoPilot();
    void SetDefault();
    void SetState(const Button buttonList[], int buttonCount,
        const Stick stickList[], const ControllerStickValueType stickXList[], const ControllerStickValueType stickYList[], int stickCount);
    void Press(Button button);
    void Release(Button button);

    void SetStickPos(Stick stick, ControllerStickValueType x, ControllerStickValueType y);
    void SetLStickPos(ControllerStickValueType x, ControllerStickValueType y);
    void SetRStickPos(ControllerStickValueType x, ControllerStickValueType y);

private:
    IoPortSender*                   m_Sender;
    int                             m_ControllerId;
    ControllerDeviceType     m_DeviceType;
    ControllerInterfaceType  m_InterfaceType;
    ControllerColor          m_MainColor;
    ControllerColor          m_SubColor;

    ControllerButtonValueType Button2Flag(Button button);
    int Color2IntValue(ControllerColor color);

    void CheckButton(Button type);
    void CheckStick(Stick type);
};
