﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "TouchAction.h"

class MultiTouchManager
{
private:
    IoPortSender         *m_Sender;
    TouchScreenInputer   *m_TouchInputer;
    TouchAction          *m_TouchAction;

    explicit MultiTouchManager(IoPortSender *sender);
    ~MultiTouchManager();
    MultiTouchManager& operator=(const MultiTouchManager &copy);
    MultiTouchManager(const MultiTouchManager &copy);

    void CorrectMaxTouchCount(int &touchCount);

public:
    static MultiTouchManager &GetInstance(IoPortSender *sender);

    TouchResult SetTouchState(int touchIdList[], int fingerIdList[], float posXList[], float posYList[], int touchCount);
    TouchResult ResetTouchState();

    // シングルタッチ
    TouchResult TouchPressDown(int touchId, int x, int y);
    TouchResult TouchPressDown(int touchId, int x, int y, int fingerId);
    TouchResult TouchPressUp(int touchId);
    TouchResult TouchMove(int touchId, int x, int y);
    TouchResult Tap(int touchId, int x, int y, int waitPress);

    // シングルタッチ - 移動
    TouchResult DragAngle(int touchId, int startX, int startY, float angle, float length,
        int actionDuration, int waitSpan, bool releaseAfter);

    TouchResult DragPos(int touchId, int startX, int startY, int endX, int endY,
        int actionDuration, int waitSpan, bool releaseAfter);


    // マルチタッチ
    TouchResult MultiTap(int touchIdList[], int touchCount, float touchPosXList[], float touchPosYList[],
        int waitPress);

    // マルチタッチ - 移動
    TouchResult MultiTouchAnimator(int touchIdList[], int touchCount,
        int startCenterX, int startCenterY,
        float centerMoveDeg, float centerMoveLength,
        float touchRelativePosXList[], float touchRelativePosYList[],
        float coordsysStartDeg, float coordsysRotateDeg,
        float startScale, float increaseScale,
        int actionDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    TouchResult MultiDragPos(int touchIdList[], int touchCount,
        int startCenterX, int startCenterY,
        int endCenterX, int endCenterY,
        float touchRelativePosXList[], float touchRelativePosYList[],
        int actionDuration,  int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    TouchResult MultiDragAngle(int touchIdList[], int touchCount,
        int startCenterX, int startCenterY,
        float centerMoveDeg, float centerMoveLength,
        float touchRelativePosXList[], float touchRelativePosYList[],
        int actionDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    TouchResult Pinch(int touchIdList[], int touchCount,
        int centerX, int centerY,
        float touchDegList[],
        float startScale, float increaseScale,
        int actionDuration, int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    TouchResult CenterTouchPinch(int touchIdList[], int touchCount,
        int centerX, int centerY,
        float touchDegList[],
        float startScale, float increaseScale,
        int actionDuration,  int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    TouchResult MultiRotate(int touchIdList[], int touchCount,
        int centerX, int centerY,
        float touchDegList[], float radius,
        float coordsysStartDeg, float coordsysRotateDeg,
        int actionDuration,  int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);

    TouchResult CenterTouchMultiRotate(int touchIdList[], int touchCount,
        int centerX, int centerY,
        float touchDegList[], float radius,
        float coordsysStartDeg, float coordsysRotateDeg,
        int actionDuration,  int waitSpan,
        int waitTouchBegin, int waitTouchEnd, bool releaseAfter);
};

