﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <Windows.h>
#include <iostream>
#include <cstdlib>
#include <cstdint>
#include <cassert>
#include "common.h"
#include "..\..\..\Hid\HidShellLibrary\HidShellLibrary.h"
#include "Common\autoTestAssistTool_PathUtil.h"

typedef int32_t(*AquireHidShellExclusiveRightFunction)(void** pOutHandle);
typedef int32_t(*ReleaseHidShellExclusiveRightFunction)(void* handle);
typedef int32_t(*AttachHidShellPortFunction)(void* handle, const void* pName);
typedef int32_t(*DetachHidShellPortFunction)(void* handle, const void* pName);
typedef int32_t(*GetHidShellPortFunction)(void* handle, uint32_t* pOutPort, const void* pName);
typedef int32_t(*GetHidShellPortListFunction)(void* handle, void* pOutList);
typedef int32_t(*GetHidShellTouchScreenStateFunction)(void* handle, void* pOutValue, uint32_t port, uint32_t direction);
typedef int32_t(*SetHidShellTouchScreenStateFunction)(void* handle, const void* pValue, uint32_t port, uint32_t direction);
typedef int32_t(*GetHidShellBasicXpadStateFunction)(void* handle, void* pOutValue, uint32_t id, uint32_t port, uint32_t direction);
typedef int32_t(*SetHidShellBasicXpadStateFunction)(void* handle, const void* pValue, uint32_t id, uint32_t port, uint32_t direction);
typedef int32_t(*GetHidShellDebugPadStateFunction)(void* handle, void* pOutValue, uint32_t port, uint32_t direction);
typedef int32_t(*SetHidShellDebugPadStateFunction)(void* handle, const void* pValue, uint32_t port, uint32_t direction);
typedef int32_t(*GetHidShellCaptureButtonStateFunction)(void* handle, void* pOutValue, uint32_t port, uint32_t direction);
typedef int32_t(*SetHidShellCaptureButtonStateFunction)(void* handle, const void* pValue, uint32_t port, uint32_t direction);
typedef int32_t(*GetHidShellHomeButtonStateFunction)(void* handle, void* pOutValue, uint32_t port, uint32_t direction);
typedef int32_t(*SetHidShellHomeButtonStateFunction)(void* handle, const void* pValue, uint32_t port, uint32_t direction);
typedef int32_t(*GetHidShellAbstractedPadStateFunction)(void* handle, void* pOutValue, uint32_t id, uint32_t port, uint32_t direction);
typedef int32_t(*SetHidShellAbstractedPadStateFunction)(void* handle, const void* pValue, uint32_t id, uint32_t port, uint32_t direction);


class HidShellLibraryWrapper
{
public:
    AquireHidShellExclusiveRightFunction    m_AquireHidShellExclusiveRight;
    ReleaseHidShellExclusiveRightFunction   m_ReleaseHidShellExclusiveRight;
    AttachHidShellPortFunction              m_AttachHidShellPort;
    DetachHidShellPortFunction              m_DetachHidShellPort;
    GetHidShellPortFunction                 m_GetHidShellPort;
    GetHidShellPortListFunction             m_GetHidShellPortList;
    GetHidShellCaptureButtonStateFunction   m_GetHidShellCaptureButtonState;
    SetHidShellCaptureButtonStateFunction   m_SetHidShellCaptureButtonState;
    GetHidShellDebugPadStateFunction        m_GetHidShellDebugPadState;
    SetHidShellDebugPadStateFunction        m_SetHidShellDebugPadState;
    GetHidShellHomeButtonStateFunction      m_GetHidShellHomeButtonState;
    SetHidShellHomeButtonStateFunction      m_SetHidShellHomeButtonState;
    GetHidShellTouchScreenStateFunction     m_GetHidShellTouchScreenState;
    SetHidShellTouchScreenStateFunction     m_SetHidShellTouchScreenState;
    GetHidShellBasicXpadStateFunction       m_GetHidShellBasicXpadState;
    SetHidShellBasicXpadStateFunction       m_SetHidShellBasicXpadState;
    GetHidShellAbstractedPadStateFunction   m_GetHidShellAbstractedPadState;
    SetHidShellAbstractedPadStateFunction   m_SetHidShellAbstractedPadState;

    static HidShellLibraryWrapper& GetInstance()
    {
        static HidShellLibraryWrapper instance;
        return instance;
    }

private:
    HidShellLibraryWrapper()
    {
        std::string libraryPath = autoTestAssistTool::util::GetSdkRootPath() + "\\Tools\\AutoTestAssistTools\\Libraries\\HidShellLibrary.dll";
        m_HidShellModule = LoadLibrary(libraryPath.c_str());

        assert(m_HidShellModule != NULL);

        bool result = false;

        result = LoadAccessMemoryMapFunctions();
        assert(result);
        result = LoadControllerFunctions();
        assert(result);
        result = LoadTouchScreenFunctions();
        assert(result);
    }

    ~HidShellLibraryWrapper()
    {
        FreeLibrary(m_HidShellModule);
    }
    bool LoadControllerFunctions()
    {
        m_GetHidShellCaptureButtonState = (GetHidShellCaptureButtonStateFunction)GetProcAddress(m_HidShellModule, "GetHidShellCaptureButtonState");
        if (m_GetHidShellCaptureButtonState == NULL)
        {
            ERRMSG("GetHidShellCaptureButtonState is not found.");
            return false;
        }
        m_SetHidShellCaptureButtonState = (SetHidShellCaptureButtonStateFunction)GetProcAddress(m_HidShellModule, "SetHidShellCaptureButtonState");
        if (m_SetHidShellCaptureButtonState == NULL)
        {
            ERRMSG("SetHidShellCaptureButtonState is not found.");
            return false;
        }
        m_GetHidShellDebugPadState = (GetHidShellDebugPadStateFunction)GetProcAddress(m_HidShellModule, "GetHidShellDebugPadState");
        if (m_GetHidShellDebugPadState == NULL)
        {
            ERRMSG("GetHidShellDebugPadState is not found.");
            return false;
        }
        m_SetHidShellDebugPadState = (SetHidShellDebugPadStateFunction)GetProcAddress(m_HidShellModule, "SetHidShellDebugPadState");
        if (m_SetHidShellDebugPadState == NULL)
        {
            ERRMSG("SetHidShellDebugPadState is not found.");
            return false;
        }
        m_GetHidShellHomeButtonState = (GetHidShellHomeButtonStateFunction)GetProcAddress(m_HidShellModule, "GetHidShellHomeButtonState");
        if (m_GetHidShellHomeButtonState == NULL)
        {
            ERRMSG("GetHidShellHomeButtonState is not found.");
            return false;
        }
        m_SetHidShellHomeButtonState = (SetHidShellHomeButtonStateFunction)GetProcAddress(m_HidShellModule, "SetHidShellHomeButtonState");
        if (m_SetHidShellHomeButtonState == NULL)
        {
            ERRMSG("SetHidShellHomeButtonState is not found.");
            return false;
        }
        m_GetHidShellBasicXpadState = (GetHidShellBasicXpadStateFunction)GetProcAddress(m_HidShellModule, "GetHidShellBasicXpadState");
        if (m_GetHidShellBasicXpadState == NULL)
        {
            ERRMSG("GetHidShellBasicXpadState is not found.");
            return false;
        }
        m_SetHidShellBasicXpadState = (SetHidShellBasicXpadStateFunction)GetProcAddress(m_HidShellModule, "SetHidShellBasicXpadState");
        if (m_SetHidShellBasicXpadState == NULL)
        {
            ERRMSG("SetHidShellBasicXpadState is not found.");
            return false;
        }
        m_GetHidShellAbstractedPadState = (GetHidShellAbstractedPadStateFunction)GetProcAddress(m_HidShellModule, "GetHidShellAbstractedPadState");
        if (m_GetHidShellAbstractedPadState == NULL)
        {
            ERRMSG("GetHidShellAbstractedPadState is not found.");
            return false;
        }
        m_SetHidShellAbstractedPadState = (SetHidShellAbstractedPadStateFunction)GetProcAddress(m_HidShellModule, "SetHidShellAbstractedPadState");
        if (m_SetHidShellAbstractedPadState == NULL)
        {
            ERRMSG("SetHidShellAbstractedPadState is not found.");
            return false;
        }
        return true;
    }
    bool LoadTouchScreenFunctions()
    {
        m_GetHidShellTouchScreenState = (GetHidShellTouchScreenStateFunction)GetProcAddress(m_HidShellModule, "GetHidShellTouchScreenState");
        if (m_GetHidShellTouchScreenState == NULL)
        {
            ERRMSG("GetHidShellTouchScreenState is not found.");
            return false;
        }
        m_SetHidShellTouchScreenState = (SetHidShellTouchScreenStateFunction)GetProcAddress(m_HidShellModule, "SetHidShellTouchScreenState");
        if (m_SetHidShellTouchScreenState == NULL)
        {
            ERRMSG("SetHidShellTouchScreenState is not found.");
            return false;
        }
        return true;
    }
    bool LoadAccessMemoryMapFunctions()
    {
        m_AquireHidShellExclusiveRight = (AquireHidShellExclusiveRightFunction)GetProcAddress(m_HidShellModule, "AquireHidShellExclusiveRight");
        if (m_AquireHidShellExclusiveRight == NULL)
        {
            ERRMSG("AquireHidShellExclusiveRight is not found.");
            return false;
        }
        m_ReleaseHidShellExclusiveRight = (ReleaseHidShellExclusiveRightFunction)GetProcAddress(m_HidShellModule, "ReleaseHidShellExclusiveRight");
        if (m_ReleaseHidShellExclusiveRight == NULL)
        {
            ERRMSG("ReleaseHidShellExclusiveRight is not found.");
            return false;
        }
        m_AttachHidShellPort = (AttachHidShellPortFunction)GetProcAddress(m_HidShellModule, "AttachHidShellPort");
        if (m_AttachHidShellPort == NULL)
        {
            ERRMSG("AttachHidShellPort is not found.");
            return false;
        }
        m_DetachHidShellPort = (DetachHidShellPortFunction)GetProcAddress(m_HidShellModule, "DetachHidShellPort");
        if (m_DetachHidShellPort == NULL)
        {
            ERRMSG("DetachHidShellPort is not found.");
            return false;
        }
        m_GetHidShellPort = (GetHidShellPortFunction)GetProcAddress(m_HidShellModule, "GetHidShellPort");
        if (m_GetHidShellPort == NULL)
        {
            ERRMSG("GetHidShellPort is not found.");
            return false;
        }
        m_GetHidShellPortList = (GetHidShellPortListFunction)GetProcAddress(m_HidShellModule, "GetHidShellPortList");
        if (m_GetHidShellPortList == NULL)
        {
            ERRMSG("GetHidShellPortList is not found.");
            return false;
        }
        return true;
    }

    HMODULE m_HidShellModule;
};
