﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Common\autoTestAssistTool_TargetManagerUtil.h"
#include <Windows.h>
#include <memory>

#define RETURN_IF_FAILURE(operation) \
do { \
    nn::tm::Error MACRO_ERROR = operation; \
    if (MACRO_ERROR != nn::tm::Error_Ok) \
    { \
        return MACRO_ERROR; \
    } \
} while (0)

namespace autoTestAssistTool { namespace util {

    nn::tm::Error GetTargetNameFromSerial(std::string* pOutName, const SerialNumberString& serialNumber)
    {
        // TargetManager に登録されているターゲットから探す
        {
            int32_t targetCount;
            RETURN_IF_FAILURE(nn::tm::GetTargetCount(&targetCount));

            std::unique_ptr<nn::tm::TargetHandle[]> pTargetHandles(new nn::tm::TargetHandle[targetCount]);
            RETURN_IF_FAILURE(nn::tm::GetTargets(pTargetHandles.get(), &targetCount, targetCount));

            for (int32_t iTarget = 0; iTarget < targetCount; iTarget++)
            {
                nn::tm::TargetSerialNumber targetSerialNumber;
                RETURN_IF_FAILURE(nn::tm::GetTargetSerialNumber(&targetSerialNumber, pTargetHandles[iTarget]));

                if (strncmp(serialNumber.value, targetSerialNumber.serialNumber, sizeof(SerialNumberString::value)) != 0)
                {
                    continue;
                }

                nn::tm::TargetIpAddress ipAddress;
                RETURN_IF_FAILURE(nn::tm::GetTargetIpAddress(&ipAddress, pTargetHandles[iTarget]));

                *pOutName = std::string(ipAddress.ipAddress);
                return nn::tm::Error_Ok;
            }
        }

        // PC に接続されているターゲットから探す
        {
            const int WaitSec = 2;
            RETURN_IF_FAILURE(nn::tm::StartDiscovery(WaitSec * 1000));

            Sleep(WaitSec * 1000 + 100);
            int32_t targetCount;
            RETURN_IF_FAILURE(nn::tm::GetDiscoveryTargetCount(&targetCount));

            std::unique_ptr<nn::tm::DiscoveryHandle[]> pDiscoveryHandles(new nn::tm::DiscoveryHandle[targetCount]);
            RETURN_IF_FAILURE(nn::tm::GetDiscoveryTargets(pDiscoveryHandles.get(), &targetCount, targetCount));

            for (int32_t iTarget = 0; iTarget < targetCount; iTarget++)
            {
                nn::tm::TargetSerialNumber targetSerialNumber;
                RETURN_IF_FAILURE(nn::tm::GetDiscoveryTargetSerialNumber(&targetSerialNumber, pDiscoveryHandles[iTarget]));

                if (strncmp(serialNumber.value, targetSerialNumber.serialNumber, sizeof(serialNumber.value)) != 0)
                {
                    continue;
                }

                nn::tm::TargetIpAddress ipAddress;
                RETURN_IF_FAILURE(nn::tm::GetDiscoveryTargetIpAddress(&ipAddress, pDiscoveryHandles[iTarget]));

                *pOutName = std::string(ipAddress.ipAddress);
                return nn::tm::Error_Ok;
            }
        }
        return nn::tm::Error_InvalidTarget;
    }
}}

