﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_UiExecuteItem.h"

ExecuteItem::ExecuteItem()
{
    m_TaskName = "Task Name";
    m_Description = "Desc";
    m_ExecuteState = ExecuteState::Unexecuted;
}

ExecuteItem::ExecuteItem(std::string name) : ExecuteItem()
{
    m_TaskName = name;
    m_Description = name;
}

ExecuteItem::ExecuteItem(std::string name, std::string description) : ExecuteItem()
{
    m_TaskName = name;
    m_Description = description;
}

void ExecuteItem::ResetState()
{
    m_ExecuteState = ExecuteState::Unexecuted;
}

const char* ExecuteItem::GetName()
{
    return m_TaskName.c_str();
}

std::string ExecuteItem::GetDescription()
{
    return m_Description;
}

void ExecuteItem::SetDescription(std::string description)
{
    m_Description = description;
}

ExecuteItem::ExecuteState ExecuteItem::GetState()
{
    return m_ExecuteState;
}

nn::Result ExecuteItem::Execute(bool* pOutValue)
{
    APPLOG_INFO("[%s] Execute\n", m_TaskName.c_str());
    m_ExecuteState = ExecuteState::Processing;
    nn::Result result = NetworkExecute(pOutValue);

    if (*pOutValue)
    {
        APPLOG_INFO("[%s] Succeeded\n", m_TaskName.c_str());
        m_ExecuteState = ExecuteState::Succeeded;
    }
    else
    {
        APPLOG_ERROR("[%s] Failed\n", m_TaskName.c_str());
        m_ExecuteState = ExecuteState::Failed;
    }
    return result;
}

nn::Result ExecuteItem::NetworkExecute(bool* pOutValue)
{
    // ネットワーク接続の確立
    nn::nifm::SubmitNetworkRequestAndWait();
    if (!nn::nifm::IsNetworkAvailable())
    {
        APPLOG_ERROR("Network is not available.\n");
        *pOutValue = false;
        NN_RESULT_SUCCESS;
    }

    nn::Result result = function(pOutValue);

    nn::nifm::CancelNetworkRequest();

    NN_RESULT_THROW(result);
}
