﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <cstdlib>
#include <nn/nn_Abort.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/init/init_Malloc.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/os.h>
#include <nn/oe.h>
#include <nn/util/util_BitUtil.h>
#include <nn/swkbd/swkbd_Api.h>
#include <nn/swkbd/swkbd_Result.h>
#include <nns/hid.h>
#include <nn/util/util_Optional.h>

#include "ShopMonitoringTool_SysFramework.h"
#ifndef gKeyboard
#define gKeyboard (Keyboard::GetInstance())
#endif

class Keyboard
{
public:
    static Keyboard& GetInstance() NN_NOEXCEPT;
    void Initialize(size_t size) NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    nn::util::optional<int> GetInteger(int _initNum) NN_NOEXCEPT;
    nn::util::optional<std::string> GetIdString(std::string initIdString) NN_NOEXCEPT;
private:
    nn::mem::StandardAllocator m_KeyboardHeapHandle;
    void* m_pMemoryHeap;
};
