﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_SysKeyboard.h"

Keyboard& Keyboard::GetInstance() NN_NOEXCEPT
{
    static Keyboard Instance;
    return Instance;
}

nn::util::optional<int> Keyboard::GetInteger(int initNum) NN_NOEXCEPT
{
    nn::swkbd::ShowKeyboardArg showKeyboardArg;
    nn::swkbd::MakePreset(&(showKeyboardArg.keyboardConfig), nn::swkbd::Preset_Default);

    showKeyboardArg.keyboardConfig.keyboardMode = nn::swkbd::KeyboardMode_Numeric;
    showKeyboardArg.keyboardConfig.inputFormMode = nn::swkbd::InputFormMode_OneLine;
    showKeyboardArg.keyboardConfig.initialCursorPos = nn::swkbd::InitialCursorPos_Last;
    showKeyboardArg.keyboardConfig.isUseUtf8 = true;
    showKeyboardArg.keyboardConfig.isUseNewLine = false;
    showKeyboardArg.keyboardConfig.textMaxLength = 4;

    // 共有メモリ用バッファの割り当て
    size_t in_heap_size = nn::swkbd::GetRequiredWorkBufferSize(false);
    void* swkbd_work_buffer = m_KeyboardHeapHandle.Allocate(in_heap_size, nn::os::MemoryPageSize);
    showKeyboardArg.workBuf = swkbd_work_buffer;
    showKeyboardArg.workBufSize = in_heap_size;

    // 初期入力文字列
    nn::swkbd::SetInitialTextUtf8(&showKeyboardArg, std::to_string(initNum).c_str());

    // 終了パラメータの設定
    size_t out_heap_size = nn::swkbd::GetRequiredStringBufferSize();
    nn::swkbd::String output_string;
    output_string.ptr = reinterpret_cast<char16_t*>(m_KeyboardHeapHandle.Allocate(out_heap_size, nn::os::MemoryPageSize));
    output_string.bufSize = out_heap_size;

    // swkbdの起動
    nn::util::optional<int> outInteger;
    nn::Result result = nn::swkbd::ShowKeyboard(&output_string, showKeyboardArg);
    if (result.IsSuccess())
    {
        outInteger = std::strtol((char*)output_string.ptr, NULL, 10);
    }
    else
    {
        outInteger = nn::util::nullopt;
    }

    // 共有メモリ用バッファの解放
    m_KeyboardHeapHandle.Free(output_string.ptr);
    m_KeyboardHeapHandle.Free(swkbd_work_buffer);

    return outInteger;
}

nn::util::optional<std::string> Keyboard::GetIdString(std::string initIdString) NN_NOEXCEPT
{
    nn::swkbd::ShowKeyboardArg showKeyboardArg;
    nn::swkbd::MakePreset(&(showKeyboardArg.keyboardConfig), nn::swkbd::Preset_DownloadCode);
    //nn::swkbd::MakePreset(&(showKeyboardArg.keyboardConfig), nn::swkbd::Preset_Default);

    showKeyboardArg.keyboardConfig.keyboardMode = nn::swkbd::KeyboardMode_Numeric;
    showKeyboardArg.keyboardConfig.inputFormMode = nn::swkbd::InputFormMode_OneLine;
    showKeyboardArg.keyboardConfig.initialCursorPos = nn::swkbd::InitialCursorPos_Last;
    showKeyboardArg.keyboardConfig.isUseUtf8 = true;
    showKeyboardArg.keyboardConfig.isUseNewLine = false;
    showKeyboardArg.keyboardConfig.textMaxLength = 16;

    // 共有メモリ用バッファの割り当て
    size_t in_heap_size = nn::swkbd::GetRequiredWorkBufferSize(false);
    void* swkbd_work_buffer = m_KeyboardHeapHandle.Allocate(in_heap_size, nn::os::MemoryPageSize);
    showKeyboardArg.workBuf = swkbd_work_buffer;
    showKeyboardArg.workBufSize = in_heap_size;

    // 初期入力文字列
    nn::swkbd::SetInitialTextUtf8(&showKeyboardArg, initIdString.c_str());

    // 終了パラメータの設定
    size_t out_heap_size = nn::swkbd::GetRequiredStringBufferSize();
    nn::swkbd::String output_string;
    output_string.ptr = reinterpret_cast<char16_t*>(m_KeyboardHeapHandle.Allocate(out_heap_size, nn::os::MemoryPageSize));
    output_string.bufSize = out_heap_size;

    // swkbdの起動
    nn::util::optional<std::string> outString;
    nn::Result result = nn::swkbd::ShowKeyboard(&output_string, showKeyboardArg);
    if (result.IsSuccess())
    {
        outString = (std::string)(char*)output_string.ptr;
    }
    else
    {
        outString = nn::util::nullopt;
    }

    // 共有メモリ用バッファの解放
    m_KeyboardHeapHandle.Free(output_string.ptr);
    m_KeyboardHeapHandle.Free(swkbd_work_buffer);

    return outString;
}

void Keyboard::Initialize(size_t size) NN_NOEXCEPT
{
    m_pMemoryHeap = new nn::Bit8[size];
    m_KeyboardHeapHandle.Initialize(m_pMemoryHeap, size);
}
void Keyboard::Finalize() NN_NOEXCEPT
{
    m_KeyboardHeapHandle.Finalize();
    delete[] reinterpret_cast<nn::Bit8*>(m_pMemoryHeap);
}
