﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>
#include <cmath>
#include <limits>
#include <algorithm>
#include <string>
#include <nn/audio.h>

#ifndef gAudio
#define gAudio (Audio::GetInstance())
#endif

class Audio
{
private:
    const int RenderRate = 32000;
    const int RenderCount = (RenderRate / 200);
    const int ChannelCount = 2;
    const char* AlarmAdpcmFileName = "rom:/audio/alerm.adpcm";
private:
    nn::os::SystemEvent m_SystemEvent;
    nn::audio::AudioRendererHandle m_AudioRendererHandle;
    nn::audio::AudioRendererConfig m_AudioRendererConfig;
    nn::audio::FinalMixType m_FinalMix;
    nn::audio::AdpcmHeaderInfo* m_pAlarmAdpcmHeader;
    nn::audio::VoiceType m_AlarmVoice;
    nn::audio::WaveBuffer m_AlarmWaveBuffer;
    void* m_AudioRendererConfigBuffer;
    void* m_AudioRendererWorkBuffer;
    void* m_AlarmDataBuffer;
    int8_t m_MainBus[2];
public:
    static Audio& GetInstance() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void PlayAlarm() NN_NOEXCEPT;
    void StopAlarm() NN_NOEXCEPT;
    void Update() NN_NOEXCEPT;
};
