﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/account/account_Types.h>
#include <nn/ec/system/ec_VirtualAccountTypes.h>
#include <nn/util/util_Optional.h>

#include "ShopMonitoringTool_SysLog.h"

nn::Result GetUidFromIndex(nn::util::optional<nn::account::Uid>* outValue, int userIndex);
nn::Result GetShopAccountStatusResponse(char* buffer, size_t bufferSize, const nn::account::Uid& uid);
nn::Result GetDeviceLinkStatusResponse(char* buffer, size_t bufferSize, const nn::account::Uid& uid);
nn::Result GetDeleteAllRightsResponse(char* buffer, size_t bufferSize, const nn::account::Uid& uid);
nn::Result GetPrepurchaseResponse(char* buffer, size_t bufferSize, const nn::account::Uid& uid, int64_t nsuid, const char* puchaseType);
nn::Result GetPurchaseResponse(char* buffer, size_t bufferSize, const nn::account::Uid& uid, int64_t nsuid, int64_t priceId, int64_t amount, const char* purchaseType);
nn::Result GetUnlinkDeviceAllResponse(char* buffer, size_t bufferSize);
nn::Result GetVirtualAccount(nn::ec::system::VirtualAccountId* outValue, char* buffer, size_t bufferSize, const nn::account::Uid& uid);
nn::Result GetSearchResponse(char* buffer, size_t bufferSize);
nn::Result GetSearchAddOnContentResponse(char* buffer, size_t bufferSize, int64_t nsuid);

enum class ShopIdType : nn::Bit8
{
    Demo
};
nn::Result GetNsuidByContentMetaId(int64_t* outValue, char* buffer, size_t bufferSize, nn::Bit64 id, ShopIdType type);
nn::Result GetDownloadDemoResponse(char* buffer, size_t bufferSize, const nn::account::Uid& uid, int64_t nsuid);

struct NintendoAccountAuthorizationCode
{
    char data[nn::account::NintendoAccountAuthorizationCodeLengthMax + 1];
};
struct NintendoAccountIdToken
{
    char data[nn::account::NintendoAccountIdTokenLengthMax + 1];
};
nn::Result GetNintendoAccountAuthorization(NintendoAccountAuthorizationCode* outAuthCode, NintendoAccountIdToken* outIdToken, const nn::account::Uid& uid);

nn::Result GetNaId(nn::Bit64* out, const nn::account::Uid& uid);
nn::Result UnregisterGameCardByNaId(nn::Bit64 naId, char* buffer, size_t bufferSize);
