﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_AppTopMenu.h"
#include "ShopMonitoringTool_AppColorPalette.h"

TopMenu::TopMenu(std::string title)
    :MenuScene(title)
{
    m_interpolatedOffsetY = 0.f;
}

void TopMenu::Draw()
{
    const int hOffset = 40;
    const int hStrOffset = (hOffset - 20) / 2;
    const int wOffset = 16;
    const int mWindowWidth = 300;

    int startX = m_DrawPosX + wOffset;
    int itemStartPosY = m_DrawPosY;


    nn::util::Color4u8Type defaultColor  = AppColor::DefaultTextColor;
    nn::util::Color4u8Type selectedColor = AppColor::SelectedColor;
    //アクティブでない場合は透過
    if (GetState() != Scene::State::EnabledActive)
    {
        defaultColor.v[3] = 50;
        selectedColor.v[3] = 50;
    }

    // Item描画
    for (int i = 0; i < m_ItemList.size(); i++)
    {
        MenuItem* pItem = GetItemList().at(i);
        if (pItem->IsSelectable()) {
            gWriter.SetCursor(startX, itemStartPosY + i*hOffset + hStrOffset);
            switch (pItem->GetState())
            {
            case MenuItem::SelectiveState::Selected:
            case MenuItem::SelectiveState::Decided:
                gWriter.SetTextColor(selectedColor);
                {
                    int originalOffsetY = i*hOffset + 1;
                    m_interpolatedOffsetY = m_interpolatedOffsetY * 0.4f + originalOffsetY * 0.6f;
                    gDrawer.DrawRect(m_DrawPosX, itemStartPosY + (int)m_interpolatedOffsetY, 5, hOffset, selectedColor);
                }
                break;
            case MenuItem::SelectiveState::Default:
            default:
                gWriter.SetTextColor(defaultColor);
                break;
            }
            gWriter.Print(pItem->GetName().c_str());
            gWriter.SetCursor(m_DrawPosX + mWindowWidth - 100, itemStartPosY + i*hOffset);
            gWriter.Print(pItem->GetValueName().c_str());
        }
        else
        {
            gWriter.SetCursor(m_DrawPosX, itemStartPosY + i*hOffset);
            gWriter.SetTextColor({ { 10,10,10,80 } });
            gWriter.Print(pItem->GetName().c_str());
        }

    }

    // NextMenu
    if (GetState() == Scene::State::EnabledInactive)
    {
        m_pNextScene->Draw();
    }
}
