﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>

#include "QCIT_AppInfo.h"
#include "QCIT_FsUtilities.h"
#include "QCIT_StringUtil.h"

namespace qcit
{

ApplicationInfo::ApplicationInfo() NN_NOEXCEPT
{

}

ApplicationInfo::~ApplicationInfo() NN_NOEXCEPT
{

}

nn::Result ApplicationInfo::ReadInfo(const std::string& inInfoFilePath) NN_NOEXCEPT
{
    std::string dataStr;
    auto result = fsutil::GetDataOfFile(inInfoFilePath, dataStr);
    if (result.IsFailure())
    {
        NN_LOG("[QCIT][Error] ApplicationInfo::ReadInfo() : GetDataOfFile() Failed : path=%s", inInfoFilePath.c_str());
        return result;
    }

    std::vector<std::string> infoList;
    ConvertToLineDelimList(dataStr, infoList);

    if (infoList.size() < 2)
    {
        NN_LOG("[QCIT][Error] ApplicationInfo::ReadInfo() : InfoCount Shortage : size=%d", infoList.size());
        return result;
    }

    // 1つ目は ApplicationID
    m_Data.applicationId = infoList.at(0);
    // 2つ目は 32ビットの Version 値
    // ファイルでは 10 進数で取得できるが、表示は 16 進数形式に変換しておく
    {
        auto verNum = StringUtil::ToBit32(infoList.at(1));
        char verBuf[16] = { 0 };
        nn::util::SNPrintf(verBuf, 16, "0x%08X", verNum);
        m_Data.version = verBuf;
    }

    return result;
}

}
