﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/account/account_Api.h>
#include <nn/account/account_Types.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ec/system/ec_DeviceAccountApi.h>
#include <nn/ec/system/ec_TicketApi.h>
#include <nn/ec/system/ec_DeviceLinkApi.h>
#include <vector>
#include "RepairAccountTransfer.h"

nn::Result RequestTransferDeviceAccount() NN_NOEXCEPT
{
    nn::ec::system::AsyncResult async;
    NN_RESULT_DO(nn::ec::system::RequestTransferDeviceAccount(&async));
    NN_RESULT_DO(async.Get());

    NN_RESULT_SUCCESS;
}

nn::Result RequestSyncTicket() NN_NOEXCEPT
{
    nn::ec::system::AsyncProgressResult async;
    NN_RESULT_DO(nn::ec::system::RequestSyncTicket(&async));
    NN_RESULT_DO(async.Get());

    NN_RESULT_SUCCESS;
}

// 1 個以上の Virtual Account がリンクされているかを確認する
nn::Result hasVirtualAccount(bool* pOutValue) NN_NOEXCEPT
{
    *pOutValue = false;

    std::vector<nn::account::Uid> uidList(nn::account::UserCountMax);
    int count;
    NN_RESULT_DO(nn::account::ListAllUsers(&count, uidList.data(), static_cast<int>(uidList.size())));

    uidList.resize(static_cast<size_t>(count));

    for (int i = 0; i < count; i++)
    {
        if (nn::ec::system::HasDeviceLink(uidList[i]))
        {
            *pOutValue = true;
            NN_RESULT_SUCCESS;
        }
    }

    NN_RESULT_SUCCESS;
}
