﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <iostream>
#include <iomanip>
#include <sstream>

#include <nn/init.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/os/os_Event.h>
#include <nn/fs.h>
#include <nn/fs/fs_Context.h>
#include <nn/fs/fs_SdCardForDebug.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataManagementPrivate.h>
#include <nn/fs/fs_SaveDataPrivate.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/fs/fs_SystemSaveDataPrivate.h>

#include <nn/npns/npns_Api.h>
#include <nn/npns/npns_ApiSystem.h>
#include <nn/ns/ns_FactoryResetApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/ns/ns_UserResourceManagementApi.h>
#include <nv/nv_MemoryManagement.h>

#include <nn/account/account_ApiPrivate.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <nn/account/http/account_Result.http.h>
#include <nn/ec/system/ec_DeviceLinkApi.h>
#include <nn/ec/system/ec_DeviceLinkSystemApi.h>
#include <nn/friends/friends_Api.h>
#include <nn/friends/friends_ApiAdmin.h>

#include <nn/migration/migration_UserMigrationApi.h>
#include <nn/migration/migration_UserMigrationApiDetail.h>
#include <nn/migration/user/migration_UserMigrationContext.h>

#include <nn/repair/repair_Api.h>
#include <nn/repair/repair_NetworkSettingsParser.h>
#include <nn/repair/repair_Sdcard.h>
#include <nn/repair/repair_Result.h>

typedef enum
{
    Role_Origin,
    Role_Destination,
    Role_Unknown,
}MigrationRole;

typedef enum
{
    State_None,
    State_Initialize,
    State_Transfer,
    State_BeforeFinalize_PreDefined,
    State_BeforeFinalize_Leave,
    State_BeforeFinalize_Delete,
    State_Finalize,
    State_OceanFinalize,
    State_Unknown,
}MigrationState;

typedef struct
{
    uint32_t                 magic;
    MigrationRole            role;
    MigrationState           state;
    uint32_t                 fwVersion;
    nn::util::Uuid           sessionId;
    nn::account::Uid         user;
    nn::Bit8                 mac[16];
}RepairAbortMigrationInfoFile;

const std::string                  g_VolumeSavedata = "syssave";
const std::string                  g_VolumeSd       = "sdcard";

// Wifi
void InitializeWifi() NN_NOEXCEPT;
void EnableWifiConnection() NN_NOEXCEPT;
void RestoreAirplaneMode() NN_NOEXCEPT;
bool WaitNetworkConnectionAvailable() NN_NOEXCEPT;
void ReleaseNetworkConnection() NN_NOEXCEPT;
nn::Result ImportNetworkSettingsFromSdCard() NN_NOEXCEPT;

// Account
nn::Result UnregisterNetworkAccountAssociation(nn::account::Uid uid, bool isWithUserDeletion, bool *pIsDeviceLinkLeave) NN_NOEXCEPT;
nn::Result DeleteNetworkAccountRelatedInformation(nn::account::Uid uid) NN_NOEXCEPT;
nn::Result DeleteUserAccountWithData(nn::account::Uid user) NN_NOEXCEPT;
nn::Result GenerateDefaultUser() NN_NOEXCEPT;
nn::Result MountRom() NN_NOEXCEPT;

// info in sd
void InitMac() NN_NOEXCEPT;
nn::Result LoadMigrationStateFromSd(nn::migration::user::LastMigrationInfo *info) NN_NOEXCEPT;
nn::Result LoadMigrationInfoFromSd(RepairAbortMigrationInfoFile *storage) NN_NOEXCEPT;
nn::Result SaveMigrationInfoToSd(RepairAbortMigrationInfoFile *storage) NN_NOEXCEPT;

// Debug
void ShowSystemSaveDataList() NN_NOEXCEPT;
void ShowUserSaveDataList() NN_NOEXCEPT;
void CreateMigrtionSaveDataForDebug(uint64_t savedataid, uint64_t process_id,
                                    MigrationRole role, nn::account::Uid uid) NN_NOEXCEPT;
void PickupRole8State(MigrationRole * pRole, MigrationState *pState) NN_NOEXCEPT;
void PickupUserFromAccountList(nn::account::Uid *puid) NN_NOEXCEPT;

