﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "NoftWriter_WaitDialog.h"

namespace noftwriter { namespace ui {

void WaitDialog::Update() NN_NOEXCEPT
{
    Window::Update();

    // Spinner の位置を調整
    graphics::Rectangle rect;
    GetClientRectangle(&rect);
    m_Spinner.SetPosition(
        rect.x + (rect.width - m_Spinner.GetWidth()) / 2,
        rect.y + rect.height - m_Spinner.GetHeight() - 24);

    m_Spinner.Update();
}

void WaitDialog::Render() NN_NOEXCEPT
{
    if (!IsVisible())
    {
        return;
    }

    Window::Render();

    auto& renderer = *GetRenderer();

    if (m_Text != nullptr)
    {
        nn::util::Float2 prevScale;
        renderer.GetTextScale(&prevScale);

        renderer.SetTextScale(1.2f, 1.2f);
        renderer.SetTextColor(GetDisplayColor(graphics::Colors::White));

        // 描画サイズを算出
        float textWidth  = renderer.CalculateTextWidth(m_Text);
        float textHeight = renderer.CalculateTextHeight(m_Text);

        graphics::Rectangle rect;
        GetClientRectangle(&rect);
        rect.height -= m_Spinner.GetHeight() + 32;

        renderer.DrawText(
            rect.x + (rect.width  - textWidth)  / 2,
            rect.y + (rect.height - textHeight) / 2,
            "%s",
            m_Text);

        renderer.SetTextScale(prevScale.x, prevScale.y);
    }

    m_Spinner.SetRenderer(&renderer);
    m_Spinner.Render();
}

}}  // noftwriter::ui
