﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "../graphics/NoftWriter_Renderer.h"
#include "NoftWriter_DisplayObject.h"

namespace noftwriter { namespace ui {

/**
 * @brief   待機状態を示すためのアニメーションです。
 */
class Spinner : public DisplayObject
{
public:
    Spinner() NN_NOEXCEPT :
        m_Width(64),
        m_Height(64),
        m_StartColor(graphics::Colors::DodgerBlue),
        m_EndColor(graphics::Colors::White),
        m_Duration(0),
        m_Interval(4)
    {}

    /**
     * @brief   描画サイズを設定します。
     */
    void SetSize(float width, float height) NN_NOEXCEPT
    {
        m_Width  = width;
        m_Height = height;
    }

    /**
     * @brief   描画サイズを取得します。
     */
    void GetSize(float* pOutWidth, float* pOutHeight) const NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(pOutWidth);
        NN_ASSERT_NOT_NULL(pOutHeight);

        *pOutWidth  = m_Width;
        *pOutHeight = m_Height;
    }

    /**
     * @brief   描画幅を取得します。
     */
    float GetWidth() const NN_NOEXCEPT
    {
        return m_Width;
    }

    /**
     * @brief   描画高を取得します。
     */
    float GetHeight() const NN_NOEXCEPT
    {
        return m_Height;
    }

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    /**
     * @brief   各セグメントを描画します。
     */
    void DrawSegments() NN_NOEXCEPT;

private:
    float               m_Width;        //!< 描画幅
    float               m_Height;       //!< 描画高
    graphics::Color     m_StartColor;   //!< 開始色
    graphics::Color     m_EndColor;     //!< 終了色
    int                 m_Duration;     //!< アニメーション時間
    int                 m_Interval;     //!< アニメーション進行間隔
};

}}  // noftwriter::ui
