﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "NfpDebugTool_Footer.h"

namespace nfpdebug { namespace ui {

void Footer::Render() NN_NOEXCEPT
{
    if (!IsVisible())
    {
        return;
    }

    auto& renderer = *GetRenderer();

    renderer.DrawHorizontalLine(
        GetX(),
        GetY(),
        1280 - GetX(),
        graphics::Colors::Silver);

    nn::util::Float2 prevScale;
    renderer.GetTextScale(&prevScale);

    renderer.SetTextScale(1.2f, 1.2f);
    renderer.SetTextColor(graphics::Colors::White);

    if (m_HelpText != nullptr)
    {
        float width = renderer.CalculateTextWidth(m_HelpText);
        renderer.DrawText(1264 - width, GetY() + 8, "%s", m_HelpText);
    }

    renderer.SetTextScale(prevScale.x, prevScale.y);
}

}}  // nfpdebug::ui
