﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/mem.h>
#include <nn/fs/fs_Bis.h>
#include "NandVerifier_HashList.h"

class LoadScene : public glv::GLV
{
private:
    glv::Label* m_Label;
    glv::Label* m_Progress;
    HashList** m_ppHashList;
public:
    explicit LoadScene(HashList** ppInHashList) NN_NOEXCEPT;
    nn::Result ReadBinaryStorage(std::unique_ptr<nn::fs::IStorage>& storage, int partitionId, int64_t offset, int64_t totalSize) NN_NOEXCEPT;
    nn::Result ReadFileSystem(HashList *hashList, std::string fileName, nn::fs::DirectoryEntryType type) NN_NOEXCEPT;
    nn::Result ReadBootPartition1(int partitionId, nn::fs::BisPartitionId id) NN_NOEXCEPT;
    nn::Result ReadBootPartition2(int partitionId, nn::fs::BisPartitionId id) NN_NOEXCEPT;
    nn::Result ReadPackage2Storage(int partitionId, nn::fs::BisPartitionId id) NN_NOEXCEPT;
    nn::Result EnumerateDirectoryEntries(HashList *hashList, std::string rootPath) NN_NOEXCEPT;
    nn::Result SelectPartition(int partitionId, nn::fs::BisPartitionId id) NN_NOEXCEPT;
    void CalculateHash() NN_NOEXCEPT;
};
