﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "hidfw/layout.h"
#include "VibrationDemo_VibrationItem.h"

namespace VibrationDemo
{
    class VibrationSwitch : public VibrationItem
    {
    public:
        VibrationSwitch() NN_NOEXCEPT;
        virtual ~VibrationSwitch() NN_NOEXCEPT {}

        virtual void Update() NN_NOEXCEPT;
        virtual void PrintText() NN_NOEXCEPT;
        virtual void Draw() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief  デフォルト値を設定
        //----------------------------------------------------------------
        virtual void SetDefault() NN_NOEXCEPT;

        bool IsEnable() const NN_NOEXCEPT { return m_IsEnableSwitch; }

    protected:
        bool    m_IsEnableSwitch;
        float   m_KbobPosition;
    };

}
