﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "hidfw/layout.h"
#include "VibrationDemo_VibrationItem.h"

namespace VibrationDemo
{
    class VibrationKnob : public VibrationItem
    {
    public:
        enum InputType
        {
            InputType_None = 0,
            InputType_Touch = 1,
            InputType_Controller,
            InputType_Gyro,
            InputType_Num
        };

    public:
        VibrationKnob() NN_NOEXCEPT;
        virtual ~VibrationKnob() NN_NOEXCEPT {}

        virtual void Update() NN_NOEXCEPT;
        virtual void PrintText() NN_NOEXCEPT;
        virtual void Draw() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief  入力処理
        //----------------------------------------------------------------
        bool UpdateTouchEvent() NN_NOEXCEPT;
        bool UpdateControllerEvent() NN_NOEXCEPT;
        bool UpdateGyroEvent() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief  振動処理
        //----------------------------------------------------------------
        void UpdateVibration() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief  デフォルト値を設定
        //----------------------------------------------------------------
        virtual void SetDefault();

        void SetValue(int value) NN_NOEXCEPT;
        void SetDefaultValue(int value) NN_NOEXCEPT;
        void SetMaxValue(int value) NN_NOEXCEPT;
        void SetMinValue(int value) NN_NOEXCEPT;

        int GetValue() NN_NOEXCEPT;

    protected:
        bool      m_IsTouchedItem;
        InputType m_InputType;

        float m_MaterValue;
        int m_DefaultValue;
        int m_MaxValue;
        int m_MinValue;
    };

}
