﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "Button.h"

namespace VibrationCollection
{
    enum SettingButtonType
    {
        // 上段
        SettingButtonType_GainLow = 0,
        SettingButtonType_PitchLow = 1,
        SettingButtonType_Speed,
        // 下段
        SettingButtonType_GainHigh,
        SettingButtonType_PitchHigh,
        SettingButtonType_Offset,

        SettingButtonType_Num
    };

    extern nns::hidfw::layout::SeekBar g_SettingSeekBar[SettingButtonType_Num];
    extern nns::hidfw::layout::ButtonGroup g_DialogSeekBar[2];
    extern nns::hidfw::layout::ButtonGroup g_DialogButtons;
    extern nns::hidfw::layout::ButtonGroup g_LoopSettingButtons;
    extern nns::hidfw::layout::ButtonGroup g_CloseButton;

    extern nns::hidfw::layout::ButtonGroup g_PreviewVibrationViewer;

    extern bool g_IsLoopStartEdit;
    extern bool g_IsLoopEndEdit;

    void ShowSetting(void* pushButton, void* param) NN_NOEXCEPT;

    void InitializePreviewVibrationValueViewer() NN_NOEXCEPT;

    void CalcPreviewVibrationValueViewer() NN_NOEXCEPT;

    void InitializeVibrationSettingSeekBar(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeVibrationSettingButtons(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeVibrationLoopSettingButtons() NN_NOEXCEPT;

    void UpdateVibrationSetting(void* executant, void* param) NN_NOEXCEPT;

    void DrawVibrationSetting(void* executant, void* param) NN_NOEXCEPT;

    void ResetVibrationSetting(void* pushButton, void* param) NN_NOEXCEPT;
}
