﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * 起動時引数の処理
 */

#include "Command.h"

namespace VibrationCollection
{
    void StartupArgument()
    {
        StartupCommandSet prevCommandSet;
        StartupCommandSet commandSet;
        prevCommandSet.Reset();
        commandSet.Reset();

        const int commandCount = nn::os::GetHostArgc();
        char**    command = nn::os::GetHostArgv();
        if (commandCount > 1)
        {
            TT_LOG("# -----------------------------------------------\n");
            TT_LOG("# (Command) CommandCount: %d\n", commandCount);
            for (int i = 1; i < commandCount; ++i)
            {
                prevCommandSet = commandSet;
                commandSet.Reset();
                commandSet.Set<StartupCommand::None>(std::strcmp("-none", command[i]) == 0);
                commandSet.Set<StartupCommand::Host>(std::strcmp("-host", command[i]) == 0);
                commandSet.Set<StartupCommand::SD>(std::strcmp("-sd", command[i]) == 0);
                if (commandSet.IsAnyOn())
                {
                    if (prevCommandSet.Test<StartupCommand::None>())
                    {
                        if (commandSet.Test<StartupCommand::SD>())
                        {
                            gFileManager.SetMountType(MountType_Host);
                            gFileManager.SetRootPath(g_HostRootPath.c_str());
                            gFileManager.ChangePath();
                            TT_LOG("# (Command) [-none] [-sd] sd disable\n");
                        }
                        if (commandSet.Test<StartupCommand::Host>())
                        {
                            gFileManager.SetMountType(MountType_Sd);
                            gFileManager.SetRootPath(g_SdRootPath.c_str());
                            gFileManager.ChangePath();
                            TT_LOG("# (Command) [-none] [-host] host disable\n");
                        }
                    }
                }
                else
                {
                    if (prevCommandSet.Test<StartupCommand::Host>())
                    {
                        g_HostRootPath = command[i];
                        gFileManager.SetMountType(MountType_Host);
                        gFileManager.SetRootPath(g_HostRootPath.c_str());
                        gFileManager.ChangePath();
                        TT_LOG("# (Command) [-host] [%s] new root path = %s\n", command[i], gFileManager.GetRootPath());
                    }
                    if (prevCommandSet.Test<StartupCommand::SD>())
                    {
                        g_SdRootPath = command[i];
                        gFileManager.SetMountType(MountType_Sd);
                        gFileManager.SetRootPath(g_SdRootPath.c_str());
                        gFileManager.ChangePath();
                        TT_LOG("# (Command) [-sd] [%s] new root path = %s\n", command[i], gFileManager.GetRootPath());
                    }
                    commandSet.Reset();
                }
            }
            TT_LOG("# -----------------------------------------------\n");
        }
    }
}
