﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/os.h>
#include <nn/oe.h>
#include <nn/util/util_StringUtil.h>

namespace nns { namespace hid { namespace util {

/**
 * @brief   言語コードです。
 */
enum class Language
{
    Japanese,   //!< 日本語
    English     //!< 英語 (北米)
};

/**
 * @brief   アプリケーションの設定を扱うクラスです。
 */
class Config final
{
    NN_DISALLOW_COPY(Config);
    NN_DISALLOW_MOVE(Config);

public:
    static Config* GetInstance() NN_NOEXCEPT;

    /**
     * @brief   現在のシステム言語を取得します。
     */
    static Language GetLanguage() NN_NOEXCEPT;

public:
    /**
     * @brief   設定を本体ストレージから読み込みます。
     */
    nn::Result Load() NN_NOEXCEPT;

    /**
     * @brief   設定を本体ストレージに保存します。
     */
    nn::Result Save() NN_NOEXCEPT;

    /**
     * @brief   設定が変更されているか判定します。
     */
    bool IsDirty() const NN_NOEXCEPT;

    /**
     * @brief   デバイスタイプを無視した強制書き込みを行うかどうかを取得します。
     */
    bool IsForceUpdateEnabled() const NN_NOEXCEPT;

    /**
     * @brief   デバイスタイプを無視した強制書き込みを行うかどうかを設定します。
     */
    void SetForceUpdateEnabled(bool isEnabled) NN_NOEXCEPT;

private:
    Config() NN_NOEXCEPT;

private:
    mutable nn::os::Mutex   m_Mutex;

    char    m_DataStorage[1024];        //!< 設定値を保持する領域
    bool    m_IsChanged;                //!< 設定が変更されているか
};

}}}  // nns::hid::util
